/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.w3c.dom.Document;

public class OGCPropertyIsBetweenTypeBindingTest
extends FilterTestSupport {
    public void testLowerBoundaryType() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals(Expression.class, (Object)this.binding(OGC.LowerBoundaryType).getType());
    }

    public void testLowerBoundaryExecutionMode() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.LowerBoundaryType).getExecutionMode());
    }

    public void testUpperBoundaryType() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals(Expression.class, (Object)this.binding(OGC.UpperBoundaryType).getType());
    }

    public void testUpperBoundaryExecutionMode() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.UpperBoundaryType).getExecutionMode());
    }

    public void testType() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals(PropertyIsBetween.class, (Object)this.binding(OGC.PropertyIsBetweenType).getType());
    }

    public void testExecutionMode() {
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.PropertyIsBetweenType).getExecutionMode());
    }

    public void testParse() throws Exception {
        FilterMockData.propertyIsBetween(this.document, this.document);
        PropertyIsBetween between = (PropertyIsBetween)this.parse();
        OGCPropertyIsBetweenTypeBindingTest.assertTrue((boolean)(between.getExpression() instanceof PropertyName));
        OGCPropertyIsBetweenTypeBindingTest.assertTrue((boolean)(between.getLowerBoundary() instanceof Literal));
        OGCPropertyIsBetweenTypeBindingTest.assertTrue((boolean)(between.getUpperBoundary() instanceof Literal));
    }

    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsBetween(), OGC.PropertyIsBetween);
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "LowerBoundary").getLength());
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "UpperBoundary").getLength());
    }

    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsBetween(), OGC.Filter);
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "LowerBoundary").getLength());
        OGCPropertyIsBetweenTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", "UpperBoundary").getLength());
    }
}

