/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_1;

import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_1.FilterMockData;
import org.geotools.filter.v1_1.FilterTestSupport;
import org.opengis.filter.PropertyIsLike;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OGCPropertyIsLikeTypeBindingTest
extends FilterTestSupport {
    public void testParse() throws Exception {
        FilterMockData.propertyIsLike(this.document, this.document);
        PropertyIsLike isLike = (PropertyIsLike)this.parse();
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)isLike.getExpression());
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)isLike.getLiteral());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)isLike.getWildCard());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)isLike.getSingleChar());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)isLike.getEscape());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((boolean)false, (boolean)isLike.isMatchingCase());
    }

    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.PropertyIsLike);
        Element pn = this.getElementByQName(doc, OGC.PropertyName);
        OGCPropertyIsLikeTypeBindingTest.assertNotNull((Object)pn);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"foo", (String)pn.getFirstChild().getNodeValue());
        Element l = this.getElementByQName(doc, OGC.Literal);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"foo", (String)l.getFirstChild().getNodeValue());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)doc.getDocumentElement().getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)doc.getDocumentElement().getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)doc.getDocumentElement().getAttribute("escapeChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"false", (String)doc.getDocumentElement().getAttribute("matchCase"));
    }

    public void testEncodeAsFilter() throws Exception {
        Document doc = this.encode(FilterMockData.propertyIsLike(), OGC.Filter);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCPropertyIsLikeTypeBindingTest.assertEquals((int)1, (int)doc.getDocumentElement().getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.Literal.getLocalPart()).getLength());
        Element e = this.getElementByQName(doc, OGC.PropertyIsLike);
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"x", (String)e.getAttribute("wildCard"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"y", (String)e.getAttribute("singleChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"z", (String)e.getAttribute("escapeChar"));
        OGCPropertyIsLikeTypeBindingTest.assertEquals((String)"false", (String)e.getAttribute("matchCase"));
    }
}

