/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import org.geotools.filter.v1_0.FilterMockData;
import org.geotools.filter.v1_0.FilterTestSupport;
import org.geotools.filter.v1_0.OGC;
import org.geotools.gml2.GML;
import org.opengis.filter.spatial.BBOX;
import org.w3c.dom.Document;

public class OGCBBoxTypeBindingTest
extends FilterTestSupport {
    public void testType() {
        OGCBBoxTypeBindingTest.assertEquals(BBOX.class, (Object)this.binding(OGC.BBOXType).getType());
    }

    public void testExecutionMode() {
        OGCBBoxTypeBindingTest.assertEquals((int)2, (int)this.binding(OGC.BBOXType).getExecutionMode());
    }

    public void testParse() throws Exception {
        FilterMockData.bbox(this.document, this.document);
        BBOX box = (BBOX)this.parse();
        OGCBBoxTypeBindingTest.assertEquals((String)"foo", (String)box.getPropertyName());
        OGCBBoxTypeBindingTest.assertEquals((double)0.0, (double)box.getMinX(), (double)0.0);
        OGCBBoxTypeBindingTest.assertEquals((double)0.0, (double)box.getMinY(), (double)0.0);
        OGCBBoxTypeBindingTest.assertEquals((double)1.0, (double)box.getMaxX(), (double)0.0);
        OGCBBoxTypeBindingTest.assertEquals((double)1.0, (double)box.getMaxY(), (double)0.0);
        OGCBBoxTypeBindingTest.assertEquals((String)"EPSG:4326", (String)box.getSRS());
    }

    public void testEncode() throws Exception {
        Document doc = this.encode(FilterMockData.bbox(), OGC.BBOX);
        OGCBBoxTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/ogc", OGC.PropertyName.getLocalPart()).getLength());
        OGCBBoxTypeBindingTest.assertEquals((int)1, (int)doc.getElementsByTagNameNS("http://www.opengis.net/gml", GML.Box.getLocalPart()).getLength());
    }
}

