/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0.capabilities;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_0.capabilities.OGC;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.ArithmeticOperators;
import org.opengis.filter.capability.ComparisonOperators;
import org.opengis.filter.capability.FilterCapabilities;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.capability.Functions;
import org.opengis.filter.capability.Operator;
import org.opengis.filter.capability.ScalarCapabilities;
import org.opengis.filter.capability.SpatialCapabilities;
import org.opengis.filter.capability.SpatialOperator;
import org.opengis.filter.capability.SpatialOperators;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMockData {
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    static Element functionName(Document document, Node parent) {
        return FilterMockData.functionName(document, parent, "foo", 2);
    }

    static Element functionName(Document document, Node parent, String name, int nargs) {
        Element function = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Function_Name"));
        function.setAttributeNS("", "nArgs", nargs + "");
        function.appendChild(document.createTextNode(name));
        return function;
    }

    static Element functionNames(Document document, Node parent) {
        Element functionNames = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Function_Names"));
        FilterMockData.functionName(document, functionNames, "foo", 2);
        FilterMockData.functionName(document, functionNames, "bar", 3);
        return functionNames;
    }

    static Element functions(Document document, Node parent) {
        Element functions = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Functions"));
        FilterMockData.functionNames(document, functions);
        return functions;
    }

    static FunctionName functionName() {
        return FilterMockData.functionName("foo", 2);
    }

    static FunctionName functionName(String name, int args) {
        return ff.functionName(name, args);
    }

    static FunctionName[] functionNames() {
        return new FunctionName[]{FilterMockData.functionName("foo", 2), FilterMockData.functionName("bar", 3)};
    }

    static Functions functions() {
        return ff.functions(FilterMockData.functionNames());
    }

    static Element arithmetic(Document document, Node parent, boolean simple) {
        Element arithmetic = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Arithmetic_Operators"));
        if (simple) {
            FilterMockData.element(document, arithmetic, OGC.Simple_Arithmetic);
        }
        FilterMockData.functions(document, arithmetic);
        return arithmetic;
    }

    static Element arithmetic(Document document, Node parent) {
        return FilterMockData.arithmetic(document, parent, true);
    }

    static ArithmeticOperators arithmetic() {
        return FilterMockData.arithmetic(true);
    }

    static ArithmeticOperators arithmetic(boolean simple) {
        return ff.arithmeticOperators(simple, FilterMockData.functions());
    }

    static Element comparison(Document document, Node parent) {
        return FilterMockData.comparison(document, parent, true);
    }

    static Element comparison(Document document, Node parent, boolean simple) {
        Element comparison = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Comparison_Operators"));
        if (simple) {
            FilterMockData.element(document, comparison, OGC.Simple_Comparisons);
        }
        FilterMockData.element(document, comparison, OGC.Like);
        FilterMockData.element(document, comparison, OGC.Between);
        FilterMockData.element(document, comparison, OGC.NullCheck);
        return comparison;
    }

    static ComparisonOperators comparison() {
        return FilterMockData.comparison(true);
    }

    static ComparisonOperators comparison(boolean simple) {
        ArrayList<Operator> o = new ArrayList<Operator>();
        if (simple) {
            o.add(ff.operator("LessThan"));
            o.add(ff.operator("LessThanOrEqualTo"));
            o.add(ff.operator("GreaterThan"));
            o.add(ff.operator("GreaterThanOrEqualTo"));
            o.add(ff.operator("EqualTo"));
            o.add(ff.operator("NotEqualTo"));
        }
        o.add(ff.operator("Like"));
        o.add(ff.operator("Between"));
        o.add(ff.operator("NullCheck"));
        return ff.comparisonOperators(o.toArray(new Operator[o.size()]));
    }

    static Element scalarCapabilities(Document document, Node parent) {
        return FilterMockData.scalarCapabilities(document, parent, true);
    }

    static Element scalarCapabilities(Document document, Node parent, boolean logical) {
        Element scalar = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Scalar_Capabilities"));
        if (logical) {
            FilterMockData.element(document, scalar, OGC.Logical_Operators);
        }
        FilterMockData.comparison(document, scalar);
        FilterMockData.arithmetic(document, scalar);
        return scalar;
    }

    static ScalarCapabilities scalarCapabilities() {
        return FilterMockData.scalarCapabilities(true);
    }

    static ScalarCapabilities scalarCapabilities(boolean logical) {
        return ff.scalarCapabilities(FilterMockData.comparison(), FilterMockData.arithmetic(), logical);
    }

    static Element spatial(Document document, Node parent) {
        Element spatial = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Spatial_Operators"));
        FilterMockData.element(document, spatial, OGC.BBOX);
        FilterMockData.element(document, spatial, OGC.Equals);
        FilterMockData.element(document, spatial, OGC.Disjoint);
        FilterMockData.element(document, spatial, OGC.Intersect);
        FilterMockData.element(document, spatial, OGC.Touches);
        FilterMockData.element(document, spatial, OGC.Contains);
        FilterMockData.element(document, spatial, OGC.Crosses);
        FilterMockData.element(document, spatial, OGC.Within);
        FilterMockData.element(document, spatial, OGC.Overlaps);
        FilterMockData.element(document, spatial, OGC.Beyond);
        FilterMockData.element(document, spatial, OGC.DWithin);
        return spatial;
    }

    static SpatialOperators spatial() {
        ArrayList<SpatialOperator> o = new ArrayList<SpatialOperator>();
        o.add(ff.spatialOperator("BBOX", null));
        o.add(ff.spatialOperator("Equals", null));
        o.add(ff.spatialOperator("Disjoint", null));
        o.add(ff.spatialOperator("Intersect", null));
        o.add(ff.spatialOperator("Touches", null));
        o.add(ff.spatialOperator("Crosses", null));
        o.add(ff.spatialOperator("Within", null));
        o.add(ff.spatialOperator("Contains", null));
        o.add(ff.spatialOperator("Overlaps", null));
        o.add(ff.spatialOperator("Beyond", null));
        o.add(ff.spatialOperator("DWithin", null));
        return ff.spatialOperators(o.toArray(new SpatialOperator[o.size()]));
    }

    static SpatialCapabilities spatialCapabilities() {
        return ff.spatialCapabilities(null, FilterMockData.spatial());
    }

    static Element spatialCapabilities(Document document, Node parent) {
        Element spatial = FilterMockData.element(document, parent, new QName("http://www.opengis.net/ogc", "Spatial_Capabilities"));
        FilterMockData.spatial(document, spatial);
        return spatial;
    }

    static FilterCapabilities capabilities() {
        return ff.capabilities("1.0.0", FilterMockData.scalarCapabilities(), FilterMockData.spatialCapabilities(), null);
    }

    static Element capabilities(Document document, Node parent) {
        Element capabilities = FilterMockData.element(document, parent, OGC.Filter_Capabilities);
        capabilities.setAttributeNS("", "version", "1.0.0");
        FilterMockData.scalarCapabilities(document, capabilities);
        FilterMockData.spatialCapabilities(document, capabilities);
        return capabilities;
    }

    static Element element(Document document, Node parent, QName name) {
        Element element = document.createElementNS(name.getNamespaceURI(), name.getLocalPart());
        if (parent != null) {
            parent.appendChild(element);
        }
        return element;
    }
}

