/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v2_0.bindings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.filter.v1_0.DistanceUnits;
import org.geotools.filter.v2_0.FES;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;

public class FESParseEncodeUtil {
    static Expression[] temporal(Node node, FilterFactory factory) {
        PropertyName name = (PropertyName)node.getChildValue(PropertyName.class);
        Object other = null;
        for (Object o : node.getChildValues(Object.class)) {
            if (o == name) continue;
            other = o;
            break;
        }
        if (other == null) {
            throw new IllegalArgumentException("Temporal filter did not specify two operands");
        }
        Object expr = null;
        expr = other instanceof Expression ? (Expression)other : factory.literal(other);
        return new Expression[]{name, expr};
    }

    static Expression getProperty(BinaryTemporalOperator op, QName name) {
        return FESParseEncodeUtil.getProperty(op.getExpression1(), op.getExpression2(), name);
    }

    static Expression getProperty(BinarySpatialOperator op, QName name) {
        return FESParseEncodeUtil.getProperty(op.getExpression1(), op.getExpression2(), name);
    }

    static List<Object[]> getProperties(DistanceBufferOperator op) {
        ArrayList<Object[]> l = new ArrayList<Object[]>();
        l.add(FESParseEncodeUtil.distanceBufferOpProperty(op.getExpression1()));
        l.add(FESParseEncodeUtil.distanceBufferOpProperty(op.getExpression2()));
        l.add(new Object[]{new QName("http://www.opengis.net/fes/2.0", "Distance"), DistanceUnits.of((double)op.getDistance(), (String)op.getDistanceUnits())});
        return l;
    }

    static Object[] distanceBufferOpProperty(Expression e) {
        if (e instanceof PropertyName) {
            return new Object[]{FES.ValueReference, e};
        }
        if (e instanceof Literal) {
            Literal l = (Literal)e;
            if (l.getValue() instanceof Geometry) {
                Geometry g = (Geometry)l.getValue();
                return new Object[]{new QName("http://www.opengis.net/gml/3.2", g.getGeometryType()), g};
            }
            return new Object[]{FES.Literal, e};
        }
        if (e instanceof Function) {
            return new Object[]{FES.Function, e};
        }
        return new Object[]{FES.expression, e};
    }

    static Expression getProperty(Expression e1, Expression e2, QName name) {
        if (FES.ValueReference.equals(name)) {
            if (e1 instanceof PropertyName) {
                return e1;
            }
            if (e2 instanceof PropertyName) {
                return e2;
            }
        }
        if (FES.expression.equals(name)) {
            if (e1 instanceof PropertyName) {
                return e2;
            }
            if (e2 instanceof PropertyName) {
                return e1;
            }
        }
        return null;
    }
}

