/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.geotools.xsd.AbstractSimpleBinding;
import org.geotools.xsd.InstanceComponent;

public class EnumSimpleBinding
extends AbstractSimpleBinding {
    Class<?> enumClass;
    QName target;
    Method get;
    Method valueOf;

    public EnumSimpleBinding(Class<?> enumClass, QName target) {
        this.enumClass = enumClass;
        this.target = target;
        try {
            this.get = enumClass.getMethod("get", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.valueOf = enumClass.getMethod("valueOf", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QName getTarget() {
        return this.target;
    }

    @Override
    public Class<?> getType() {
        return this.enumClass;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        Object result = this.get(value.toString());
        if (result == null) {
            result = this.get(value.toString().toUpperCase());
        }
        return result;
    }

    Object get(String value) throws Exception {
        try {
            if (this.get != null) {
                return this.get.invoke(null, value);
            }
        }
        catch (Exception e1) {
            try {
                if (this.valueOf != null) {
                    return this.valueOf.invoke(null, value);
                }
            }
            catch (Exception e2) {
                return null;
            }
        }
        return null;
    }
}

