/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.geotools.ml.MLConfiguration;
import org.geotools.ml.Mail;
import org.geotools.ml.bindings.MLSchemaLocationResolver;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.geotools.xsd.Parser;
import org.geotools.xsd.ParserDelegate;
import org.geotools.xsd.ParserDelegate2;
import org.geotools.xsd.Text;
import org.geotools.xsd.XMLConfiguration;
import org.geotools.xsd.XSD;
import org.geotools.xsd.impl.Handler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;

public class ParserTest {
    @Test
    public void testParseEntityResolver() throws Exception {
        Parser parser = new Parser((Configuration)new XMLConfiguration());
        final AtomicBoolean resolverUsed = new AtomicBoolean(false);
        parser.setEntityResolver((EntityResolver)new EntityResolver2(){

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                return null;
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                if (systemId.equals("./mails.xsd")) {
                    resolverUsed.set(true);
                }
                return null;
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("./mails.xsd")) {
                    resolverUsed.set(true);
                }
                return null;
            }
        });
        parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-local-schema.xml"));
        Assert.assertTrue((String)"The resolver was not used?", (boolean)resolverUsed.get());
    }

    @Test
    public void testParse() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        List mails = (List)parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails.xml"));
        Assert.assertEquals((long)2L, (long)mails.size());
        Mail mail = (Mail)mails.get(0);
        Assert.assertEquals((long)0L, (long)mail.getId().intValue());
        mail = (Mail)mails.get(1);
        Assert.assertEquals((long)1L, (long)mail.getId().intValue());
    }

    @Test
    public void testParseValid() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        parser.setValidating(true);
        parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails.xml"));
        Assert.assertEquals((long)0L, (long)parser.getValidationErrors().size());
    }

    @Test
    public void testParseNull() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        parser.setValidating(true);
        List mails = (List)parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("null-mail.xml"));
        Assert.assertEquals((long)0L, (long)parser.getValidationErrors().size());
        Assert.assertEquals((long)1L, (long)mails.size());
        Mail mail = (Mail)mails.get(0);
        Assert.assertNull((Object)mail.getBody());
    }

    @Test
    public void testParseInValid() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        parser.setValidating(true);
        parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-invalid.xml"));
        Assert.assertNotEquals((long)0L, (long)parser.getValidationErrors().size());
        parser.setFailOnValidationError(true);
        try {
            parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-invalid.xml"));
            Assert.fail((String)"should have thrown an error with setFailOnValidationError set");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testValidate() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        parser.validate(MLSchemaLocationResolver.class.getResourceAsStream("mails-invalid.xml"));
        Assert.assertNotEquals((long)0L, (long)parser.getValidationErrors().size());
        parser.setFailOnValidationError(true);
        try {
            parser.validate(MLSchemaLocationResolver.class.getResourceAsStream("mails-invalid.xml"));
            Assert.fail((String)"should have thrown an error with setFailOnValidationError set");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testParserDelegate() throws Exception {
        MLConfiguration config = new MLConfiguration();
        MyParserDelegate delegate = new MyParserDelegate();
        Assert.assertFalse((boolean)delegate.foo);
        Assert.assertFalse((boolean)delegate.bar);
        config.getContext().registerComponentInstance((Object)delegate);
        Parser parser = new Parser((Configuration)config);
        parser.parse(ParserTest.class.getResourceAsStream("parserDelegate.xml"));
        Assert.assertTrue((boolean)delegate.foo);
        Assert.assertTrue((boolean)delegate.bar);
    }

    @Test
    public void testMixedContent() throws Exception {
        final StringBuffer sb = new StringBuffer();
        XSD xsd = new XSD(){

            public String getSchemaLocation() {
                return ParserTest.class.getResource("mixed.xsd").getFile();
            }

            public String getNamespaceURI() {
                return "http://geotools.org/test";
            }
        };
        Configuration cfg = new Configuration(xsd){

            protected void registerBindings(Map<QName, Object> bindings) {
                bindings.put(new QName("http://geotools.org/test", "MixedType"), (Object)new MixedTypeBinding(sb));
            }

            protected void configureParser(Parser parser) {
                parser.setHandleMixedContent(true);
            }
        };
        Parser p = new Parser(cfg);
        p.parse(this.getClass().getResourceAsStream("mixed1.xml"));
        Assert.assertEquals((Object)"Hello 'there' how are 'you'?", (Object)sb.toString());
        sb.setLength(0);
        p.parse(this.getClass().getResourceAsStream("mixed2.xml"));
        Assert.assertEquals((Object)"Hello 'there' how are 'you' ?", (Object)sb.toString());
    }

    @Test
    public void testParseWithEntityResolver() throws Exception {
        Parser parser = new Parser((Configuration)new MLConfiguration());
        try {
            parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
            Assert.fail((String)"parsing should throw an exception since referenced file does not exist");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            parser.validate(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
            Assert.fail((String)"validating should throw an exception since referenced file does not exist");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        parser.setEntityResolver((EntityResolver)new EntityResolver2(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource();
            }

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                return new InputSource();
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                return new InputSource();
            }
        });
        try {
            parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
            Assert.fail((String)"parsing an XML with external entities should throw a MalformedURLException");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            parser.validate(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
            Assert.fail((String)"validating an XML with external entities should throw a MalformedURLException");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        parser.setEntityResolver((EntityResolver)new EntityResolver2(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if ("file:///this/file/does/not/exist".equals(systemId)) {
                    return new InputSource(new StringReader("hello"));
                }
                return new InputSource();
            }

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                return null;
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                if ("file:///this/file/does/not/exist".equals(systemId)) {
                    return new InputSource(new StringReader("hello"));
                }
                return new InputSource();
            }
        });
        parser.parse(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
        parser.validate(MLSchemaLocationResolver.class.getResourceAsStream("mails-external-entities.xml"));
    }

    @Test
    public void testEntityExpansionLimitException() throws Exception {
        final StringBuffer sb = new StringBuffer();
        XSD xsd = new XSD(){

            public String getSchemaLocation() {
                return ParserTest.class.getResource("mixed.xsd").getFile();
            }

            public String getNamespaceURI() {
                return "http://geotools.org/test";
            }
        };
        Configuration cfg = new Configuration(xsd){

            protected void registerBindings(Map<QName, Object> bindings) {
                bindings.put(new QName("http://geotools.org/test", "MixedType"), (Object)new MixedTypeBinding(sb));
            }

            protected void configureParser(Parser parser) {
                parser.setHandleMixedContent(true);
            }
        };
        Parser p = new Parser(cfg);
        p.setEntityExpansionLimit(Integer.valueOf(1));
        SAXParseException expected = null;
        try {
            p.parse(this.getClass().getResourceAsStream("entityExpansionLimit.xml"));
        }
        catch (SAXParseException ex) {
            expected = ex;
        }
        Assert.assertNotNull((Object)expected);
        Assert.assertTrue((boolean)expected.getMessage().contains("JAXP00010001"));
    }

    @Test
    public void testEntityExpansionLimitAllowed() throws Exception {
        final StringBuffer sb = new StringBuffer();
        XSD xsd = new XSD(){

            public String getSchemaLocation() {
                return ParserTest.class.getResource("mixed.xsd").getFile();
            }

            public String getNamespaceURI() {
                return "http://geotools.org/test";
            }
        };
        Configuration cfg = new Configuration(xsd){

            protected void registerBindings(Map<QName, Object> bindings) {
                bindings.put(new QName("http://geotools.org/test", "MixedType"), (Object)new MixedTypeBinding(sb));
            }

            protected void configureParser(Parser parser) {
                parser.setHandleMixedContent(true);
            }
        };
        Parser p = new Parser(cfg);
        p.setEntityExpansionLimit(Integer.valueOf(100));
        SAXParseException unexpected = null;
        try {
            p.parse(this.getClass().getResourceAsStream("entityExpansionLimit.xml"));
        }
        catch (SAXParseException ex) {
            unexpected = ex;
        }
        Assert.assertNull((Object)unexpected);
    }

    public static class MixedTypeBinding
    extends AbstractComplexBinding {
        StringBuffer sb = new StringBuffer();

        public MixedTypeBinding(StringBuffer sb) {
            this.sb = sb;
        }

        public QName getTarget() {
            return new QName("http://geotools.org/test", "MixedType");
        }

        public Class getType() {
            return Object.class;
        }

        public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
            for (Node n : node.getChildren()) {
                if (n.getValue() instanceof Text) {
                    this.sb.append(((Text)n.getValue()).getValue());
                    continue;
                }
                this.sb.append("'").append(n.getValue()).append("'");
            }
            return value;
        }
    }

    static class MyParserDelegate
    implements ParserDelegate,
    ParserDelegate2 {
        boolean foo = false;
        boolean bar = false;

        MyParserDelegate() {
        }

        public boolean canHandle(QName elementName) {
            return "parserDelegateElement".equals(elementName.getLocalPart());
        }

        public void initialize(QName elementName) {
        }

        public Object getParsedObject() {
            return null;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.bar && "bar".equals(new String(ch, start, length))) {
                this.bar = true;
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if (!this.foo && "foo".equals(localName)) {
                this.foo = true;
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public boolean canHandle(QName elementName, Attributes attributes, Handler handler, Handler parent) {
            return this.canHandle(elementName);
        }
    }
}

