/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.QName;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;
import org.junit.Assert;
import org.junit.Test;

public class XSDoubleStrategyTest
extends TestSchema {
    @Test
    public void testParse() throws Exception {
        this.validateValues("-1E4", (Object)-10000.0);
        this.validateValues("1267.43233E12", (Object)1.26743233E15);
        this.validateValues("12.78e-2", (Object)0.1278);
        this.validateValues("12", (Object)12.0);
        this.validateValues("-0", (Object)Double.valueOf("-0"));
        this.validateValues("0", (Object)0.0);
        ElementInstance element = this.element("INF", XS.DOUBLE);
        Assert.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)this.strategy.parse((InstanceComponent)element, (Object)"INF"));
    }

    @Test
    public void testIntegerParse() throws Exception {
        ElementInstance element = this.element("12345", XS.INTEGER);
        Assert.assertEquals((Object)12345.0, (Object)this.strategy.parse((InstanceComponent)element, (Object)"12345"));
    }

    @Override
    protected QName getQName() {
        return XS.DOUBLE;
    }

    @Test
    public void testParseEmptyStringAsNull() throws Exception {
        this.validateValues("", null);
        this.validateValues("\t", null);
    }
}

