/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs;

import java.lang.reflect.Field;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.ElementInstance;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaTest
extends TestSchema {
    @Test
    public void testInitialize() {
        Assert.assertNotNull((Object)url);
        Assert.assertNotNull((Object)schema);
        Assert.assertNotNull((Object)factory);
    }

    @Test
    public void testStratagyQName() throws Exception {
        Assert.assertNotNull((Object)this.stratagy(XS.ANYSIMPLETYPE));
    }

    @Test
    public void testStratagyName() throws Exception {
        Assert.assertNotNull((Object)this.stratagy("anySimpleType"));
        try {
            this.stratagy("bork");
            Assert.fail((String)"bork should not be found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testXS() throws Exception {
        Assert.assertEquals((Object)XS.ANYSIMPLETYPE, (Object)this.xs("anySimpleType"));
        try {
            this.xs("bork");
            Assert.fail((String)"bork should not be found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSchemaIdentiy() {
        Assert.assertNotNull((Object)schema);
        Assert.assertNotNull((Object)xsd);
        Assert.assertEquals((Object)"1.0", (Object)xsd.getVersion());
    }

    @Test
    public void testXSDSimpleTypes() throws Exception {
        XSDSimpleTypeDefinition any = this.xsdSimple("anySimpleType");
        Assert.assertNotNull((String)"Found", (Object)any);
    }

    @Test
    public void testSchemaSimpleTypes() throws Exception {
        XSDSimpleTypeDefinition any = this.xsdSimple("anySimpleType");
        Assert.assertNotNull((String)"Found", (Object)any);
    }

    @Test
    public void testAllSimpleTypes() throws Exception {
        Field[] fields;
        Class<XS> xs = XS.class;
        for (Field field : fields = xs.getFields()) {
            if (field.getType() != QName.class) continue;
            QName name = (QName)field.get(null);
            this.xsdSimple(name.getLocalPart());
        }
    }

    @Test
    public void testElement() {
        ElementInstance element = this.element(" hello world ", XS.ANYSIMPLETYPE);
        Assert.assertEquals((Object)" hello world ", (Object)element.getText());
        Assert.assertEquals((Object)this.xsdSimple(XS.ANYSIMPLETYPE.getLocalPart()), (Object)element.getElementDeclaration().getType());
    }

    @Override
    protected QName getQName() {
        return null;
    }
}

