/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.geotools.xs.bindings.XSQNameBinding;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.xml.sax.helpers.NamespaceSupport;

public class XSQNameBindingTest
extends TestCase {
    XSQNameBinding binding;

    protected void setUp() throws Exception {
        NamespaceSupport ns = new NamespaceSupport();
        ns.declarePrefix("foo", "http://foo");
        this.binding = new XSQNameBinding((NamespaceContext)new NamespaceSupportWrapper(ns));
    }

    public void testWithPrefix() throws Exception {
        QName qName = (QName)this.binding.parse(null, (Object)"foo:bar");
        XSQNameBindingTest.assertNotNull((Object)qName);
        XSQNameBindingTest.assertEquals((String)"foo", (String)qName.getPrefix());
        XSQNameBindingTest.assertEquals((String)"http://foo", (String)qName.getNamespaceURI());
        XSQNameBindingTest.assertEquals((String)"bar", (String)qName.getLocalPart());
    }

    public void testWithNoPrefix() throws Exception {
        QName qName = (QName)this.binding.parse(null, (Object)"bar:foo");
        XSQNameBindingTest.assertNotNull((Object)qName);
        XSQNameBindingTest.assertEquals((String)"bar", (String)qName.getPrefix());
        XSQNameBindingTest.assertEquals((String)"", (String)qName.getNamespaceURI());
        XSQNameBindingTest.assertEquals((String)"foo", (String)qName.getLocalPart());
    }
}

