/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs;

import java.lang.reflect.Field;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.ElementInstance;

public class TestSchemaTest
extends TestSchema {
    public void testInitialize() {
        TestSchemaTest.assertNotNull((Object)url);
        TestSchemaTest.assertNotNull((Object)schema);
        TestSchemaTest.assertNotNull((Object)factory);
    }

    public void testStratagyQName() throws Exception {
        TestSchemaTest.assertNotNull((Object)this.stratagy(XS.ANYSIMPLETYPE));
    }

    public void testStratagyName() throws Exception {
        TestSchemaTest.assertNotNull((Object)this.stratagy("anySimpleType"));
        try {
            this.stratagy("bork");
            TestSchemaTest.fail((String)"bork should not be found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testXS() throws Exception {
        TestSchemaTest.assertEquals((Object)XS.ANYSIMPLETYPE, (Object)this.xs("anySimpleType"));
        try {
            this.xs("bork");
            TestSchemaTest.fail((String)"bork should not be found");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSchemaIdentiy() {
        TestSchemaTest.assertNotNull((Object)schema);
        TestSchemaTest.assertNotNull((Object)xsd);
        TestSchemaTest.assertEquals((String)"1.0", (String)xsd.getVersion());
    }

    public void testXSDSimpleTypes() throws Exception {
        XSDSimpleTypeDefinition any = this.xsdSimple("anySimpleType");
        TestSchemaTest.assertNotNull((String)"Found", (Object)any);
    }

    public void testSchemaSimpleTypes() throws Exception {
        XSDSimpleTypeDefinition any = this.xsdSimple("anySimpleType");
        TestSchemaTest.assertNotNull((String)"Found", (Object)any);
    }

    public void testAllSimpleTypes() throws Exception {
        Class<XS> xs = XS.class;
        Field[] fields = xs.getFields();
        for (int i = 0; i < fields.length; ++i) {
            QName name;
            XSDSimpleTypeDefinition aXsd;
            Field field = fields[i];
            if (field.getType() == QName.class && (aXsd = this.xsdSimple((name = (QName)field.get(null)).getLocalPart())) != null) continue;
        }
    }

    public void testElement() {
        ElementInstance element = this.element(" hello world ", XS.ANYSIMPLETYPE);
        TestSchemaTest.assertEquals((String)" hello world ", (String)element.getText());
        TestSchemaTest.assertEquals((Object)this.xsdSimple(XS.ANYSIMPLETYPE.getLocalPart()), (Object)element.getElementDeclaration().getType());
    }

    @Override
    protected QName getQName() {
        return null;
    }
}

