/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDParser;
import org.geotools.util.URLs;
import org.geotools.xs.XS;
import org.geotools.xs.XSConfiguration;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.SimpleBinding;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.ElementImpl;
import org.geotools.xsd.impl.PicoMap;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public abstract class TestSchema
extends TestCase {
    public static URL url = TestSchema.class.getResource("sample.xsd");
    public static XSDSchema schema;
    public static XSDSchema xsd;
    public static BindingLoader factory;
    protected XSDSimpleTypeDefinition typeDef;
    protected SimpleBinding strategy;
    protected QName qname;

    public TestSchema() {
    }

    public TestSchema(String name) {
        super(name);
    }

    public XSDSimpleTypeDefinition xsdSimple(String name) {
        Map simpleTypes = xsd.getSimpleTypeIdMap();
        return (XSDSimpleTypeDefinition)simpleTypes.get(name);
    }

    public QName xs(String name) throws Exception {
        Class<XS> xs = XS.class;
        Field[] fields = xs.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().equalsIgnoreCase(name)) continue;
            return (QName)field.get(null);
        }
        throw new IllegalArgumentException(name);
    }

    public Binding stratagy(QName qname) throws Exception {
        return factory.loadBinding(qname, (PicoContainer)new DefaultPicoContainer());
    }

    public Binding stratagy(String name) throws Exception {
        return factory.loadBinding(this.xs(name), (PicoContainer)new DefaultPicoContainer());
    }

    public ElementInstance element(String text, QName qname) {
        XSDElementDeclaration declaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        declaration.setTypeDefinition((XSDTypeDefinition)this.xsdSimple(qname.getLocalPart()));
        ElementImpl element = new ElementImpl(declaration);
        element.setText(text);
        return element;
    }

    public ElementInstance element(String text, QName original, String name) {
        try {
            File temp = File.createTempFile("name", "xsd");
            FileWriter file = new FileWriter(temp);
            BufferedWriter buff = new BufferedWriter(file);
            PrintWriter print = new PrintWriter(buff);
            print.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>  <xsd:schema xmlns:my=\"http://mails/refractions/net\"              xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"              targetNamespace=\"http://localhost//test\">  <xsd:element name=\"" + name + "\" type=\"xsd:" + original.getLocalPart() + "\"/></xsd:schema>");
            URL url = URLs.fileToUrl((File)temp);
            XSDParser parser = new XSDParser(Collections.emptyMap());
            parser.parse(url.toString());
            XSDSchema schema = parser.getSchema();
            Map map = schema.getSimpleTypeIdMap();
            return (ElementInstance)map.get(name);
        }
        catch (Throwable t) {
            Logger.getGlobal().log(Level.INFO, "", t);
            return null;
        }
    }

    public void validateValues(String given, Object expected) throws Exception {
        Object result = this.strategy.parse((InstanceComponent)this.element(given, this.qname), (Object)given);
        TestSchema.assertEquals((Object)expected, (Object)result);
    }

    protected abstract QName getQName();

    protected void setUp() throws Exception {
        super.setUp();
        this.qname = this.getQName();
        if (this.qname != null) {
            this.typeDef = this.xsdSimple(this.qname.getLocalPart());
            this.strategy = (SimpleBinding)this.stratagy(this.qname);
        }
    }

    public void testSetUp() {
        if (this.getQName() != null) {
            TestSchema.assertNotNull((String)"XSD typedef", (Object)this.typeDef);
            TestSchema.assertNotNull((Object)this.strategy);
        }
    }

    static {
        try {
            schema = Schemas.parse((String)url.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        xsd = schema.getSchemaForSchema();
        HashMap bindings = new HashMap();
        new XSConfiguration().registerBindings((MutablePicoContainer)new PicoMap(bindings));
        factory = new BindingLoader(bindings);
    }
}

