/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geotools.xml.InstanceComponent;
import org.geotools.xml.SimpleBinding;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;

public class XSDateBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DATE;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Class getType() {
        return Date.class;
    }

    @Override
    public Date parse(InstanceComponent instance, Object value) throws Exception {
        Calendar calendar = DatatypeConverterImpl.getInstance().parseDate((String)value);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Date date = (Date)object;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        return DatatypeConverterImpl.getInstance().printDate(calendar);
    }
}

