/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Node;
import org.geotools.xsd.Text;

public class NodeImpl
implements Node {
    private InstanceComponent component;
    private Object value;
    List<Node> children;
    List<Node> attributes;
    Node parent;

    public NodeImpl(InstanceComponent component) {
        this.component = component;
        this.children = new ArrayList<Node>();
        this.attributes = new ArrayList<Node>();
    }

    public NodeImpl(InstanceComponent component, Object value) {
        this(component);
        this.value = value;
    }

    @Override
    public InstanceComponent getComponent() {
        return this.component;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean hasChild(String name) {
        if (name == null) {
            return false;
        }
        for (Node child : this.children) {
            if (!name.equals(child.getComponent().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChild(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        for (Node child : this.children) {
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getNChildren() {
        return this.children.size();
    }

    @Override
    public List<Node> getChildren(String name) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (name == null) {
            return matches;
        }
        for (Node child : this.children) {
            if (!name.equals(child.getComponent().getName())) continue;
            matches.add(child);
        }
        return matches;
    }

    @Override
    public List<Node> getChildren(Class<?> clazz) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (clazz == null) {
            return matches;
        }
        for (Node child : this.children) {
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            matches.add(child);
        }
        return matches;
    }

    @Override
    public Node getChild(String name) {
        if (name == null) {
            return null;
        }
        for (Node child : this.children) {
            if (!name.equals(child.getComponent().getName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public Node getChild(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Node child : this.children) {
            if (child.getValue() == null || !clazz.isAssignableFrom(child.getValue().getClass())) continue;
            return child;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        for (Node att : this.attributes) {
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name == null) {
            return false;
        }
        for (Node att : this.attributes) {
            if (!name.equals(att.getComponent().getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getAttributes() {
        return new ArrayList<Node>(this.attributes);
    }

    @Override
    public List<Node> getAttributes(Class<?> clazz) {
        ArrayList<Node> matches = new ArrayList<Node>();
        if (clazz == null) {
            return matches;
        }
        for (Node att : this.attributes) {
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            matches.add(att);
        }
        return matches;
    }

    public int getNAttributes() {
        return this.attributes.size();
    }

    @Override
    public Node getAttribute(String name) {
        if (name == null) {
            return null;
        }
        for (Node att : this.attributes) {
            if (!name.equals(att.getComponent().getName())) continue;
            return att;
        }
        return null;
    }

    @Override
    public Node getAttribute(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Node att : this.attributes) {
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return att;
        }
        return null;
    }

    @Override
    public Object getAttributeValue(String name) {
        Node node = this.getAttribute(name);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    @Override
    public Object getAttributeValue(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Node att : this.attributes) {
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            return att.getValue();
        }
        return null;
    }

    @Override
    public List<Object> getAttributeValues(Class<?> clazz) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (clazz == null) {
            return matches;
        }
        for (Node att : this.attributes) {
            if (att.getValue() == null || !clazz.isAssignableFrom(att.getValue().getClass())) continue;
            matches.add(att.getValue());
        }
        return matches;
    }

    public String toString() {
        return this.getComponent().getName() + "=" + String.valueOf(this.getValue());
    }

    @Override
    public Object getChildValue(int index) {
        return this.children.get(index).getValue();
    }

    @Override
    public Object getChildValue(String name) {
        Node node = this.getChild(name);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    @Override
    public <T> T getChildValue(Class<T> clazz) {
        Node node = this.getChild(clazz);
        if (node != null) {
            return clazz.cast(node.getValue());
        }
        return null;
    }

    @Override
    public List<Object> getChildValues(String name) {
        ArrayList<Object> matches = new ArrayList<Object>();
        if (name == null) {
            return matches;
        }
        for (Node child : this.children) {
            if (!name.equals(child.getComponent().getName())) continue;
            matches.add(child.getValue());
        }
        return matches;
    }

    @Override
    public <T> List<T> getChildValues(Class<T> clazz) {
        ArrayList<T> matches = new ArrayList<T>();
        if (clazz == null) {
            return matches;
        }
        for (Node child : this.children) {
            Object parsed = child.getValue();
            if (parsed == null || !clazz.isAssignableFrom(parsed.getClass())) continue;
            matches.add(clazz.cast(parsed));
        }
        return matches;
    }

    @Override
    public Object getAttributeValue(String name, Object defaultValue) {
        Object o = this.getAttributeValue(name);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    public Object getAttributeValue(Class clazz, Object defaultValue) {
        Object o = this.getAttributeValue(clazz);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    @Override
    public Object getChildValue(String name, Object defaultValue) {
        Object o = this.getChildValue(name);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    @Override
    public <T> T getChildValue(Class<T> clazz, T defaultValue) {
        T o = this.getChildValue(clazz);
        if (o == null) {
            o = defaultValue;
        }
        return clazz.cast(o);
    }

    public void addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
    }

    public Node removeChild(String name) {
        Node child = this.getChild(name);
        if (child != null && this.children.remove(child)) {
            child.setParent(null);
        }
        return child;
    }

    public void removeChild(Node child) {
        if (this.children.remove(child)) {
            child.setParent(null);
        }
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void addAttribute(Node attribute) {
        this.attributes.add(attribute);
    }

    public Node removeAttribute(String name) {
        Node attribute = this.getAttribute(name);
        if (attribute != null) {
            this.attributes.remove(attribute);
        }
        return attribute;
    }

    public void collapseWhitespace() {
        Text t;
        Iterator<Node> it = this.children.iterator();
        while (it.hasNext() && (t = this.text(it.next())) != null) {
            if (t.isWhitespace()) {
                it.remove();
                continue;
            }
            t.trimLeading();
            break;
        }
        for (int i = this.children.size() - 1; i > -1 && (t = this.text(this.children.get(i))) != null; --i) {
            if (!t.isWhitespace()) {
                t.trimTrailing();
                break;
            }
            this.children.remove(i);
        }
        boolean remove = false;
        Iterator<Node> it2 = this.children.iterator();
        while (it2.hasNext()) {
            Text t2 = this.text(it2.next());
            if (t2 == null) continue;
            t2.trimInner();
            if (t2.isWhitespace()) {
                if (remove) {
                    it2.remove();
                    continue;
                }
                remove = true;
                continue;
            }
            remove = false;
        }
    }

    Text text(Node n) {
        if (n.getValue() instanceof Text) {
            return (Text)n.getValue();
        }
        return null;
    }
}

