/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ComplexBinding;
import org.geotools.xsd.impl.BindingWalker;

public class GetPropertiesExecutor
implements BindingWalker.Visitor {
    Object parent;
    XSDElementDeclaration element;
    List<Object[]> properties;

    public GetPropertiesExecutor(Object parent, XSDElementDeclaration element) {
        this.parent = parent;
        this.element = element;
        this.properties = new ArrayList<Object[]>();
    }

    public List<Object[]> getProperties() {
        return this.properties;
    }

    @Override
    public void visit(Binding binding) {
        if (binding instanceof ComplexBinding) {
            ComplexBinding complex = (ComplexBinding)binding;
            try {
                List<Object[]> properties = complex.getProperties(this.parent, this.element);
                if (properties != null) {
                    this.properties.addAll(properties);
                }
            }
            catch (Exception e) {
                String msg = "Failed to get properties. Binding for " + String.valueOf(complex.getTarget());
                throw new RuntimeException(msg, e);
            }
        }
    }
}

