/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDUtil;
import org.geotools.xsd.AttributeInstance;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Node;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.Text;
import org.geotools.xsd.TextInstance;
import org.geotools.xsd.impl.AttributeImpl;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.ContextInitializer;
import org.geotools.xsd.impl.ElementHandler;
import org.geotools.xsd.impl.ElementImpl;
import org.geotools.xsd.impl.ElementInitializer;
import org.geotools.xsd.impl.Handler;
import org.geotools.xsd.impl.HandlerImpl;
import org.geotools.xsd.impl.NodeImpl;
import org.geotools.xsd.impl.ParseExecutor;
import org.geotools.xsd.impl.ParserHandler;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementHandlerImpl
extends HandlerImpl
implements ElementHandler {
    Handler parent;
    XSDElementDeclaration content;
    ElementImpl element;
    ParserHandler parser;
    Binding strategy;
    NodeImpl node;
    Object value;

    public ElementHandlerImpl(XSDElementDeclaration content, Handler parent, ParserHandler parser) {
        this.content = content;
        this.parent = parent;
        this.parser = parser;
    }

    @Override
    public void startElement(QName qName, Attributes attributes) throws SAXException {
        int i;
        ArrayList<AttributeImpl> atts = new ArrayList<AttributeImpl>();
        for (i = 0; i < attributes.getLength(); ++i) {
            String name;
            String uri;
            QName attQName;
            XSDAttributeDeclaration decl;
            String rawAttQName = attributes.getQName(i);
            if (rawAttQName != null) {
                if (rawAttQName.startsWith("xmlns:")) continue;
                if (rawAttQName.endsWith("schemaLocation")) {
                    String uri2;
                    String prefix = "";
                    if (rawAttQName.indexOf(58) != -1) {
                        prefix = rawAttQName.substring(0, rawAttQName.indexOf(58));
                    }
                    if ((uri2 = this.parser.getNamespaceSupport().getURI(prefix)) != null && uri2.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                }
            }
            if ((decl = Schemas.getAttributeDeclaration(this.content, attQName = new QName(uri = attributes.getURI(i), name = attributes.getLocalName(i)))) == null && !this.parser.isStrict()) {
                if (this.parser.getLogger().isLoggable(Level.FINE)) {
                    this.parser.getLogger().fine("Parsing unknown attribute: " + String.valueOf(attQName));
                }
                decl = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
                decl.setName(attQName.getLocalPart());
                decl.setTargetNamespace(attQName.getNamespaceURI());
                XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)XSDUtil.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema").getSimpleTypeIdMap().get("string");
                decl.setTypeDefinition(type);
            }
            if (decl != null) {
                AttributeImpl att = new AttributeImpl(decl);
                att.setNamespace(decl.getTargetNamespace());
                att.setName(decl.getName());
                att.setText(attributes.getValue(i));
                atts.add(att);
                continue;
            }
            this.parser.getLogger().warning("Could not find attribute declaration: " + String.valueOf(attQName));
        }
        this.element = new ElementImpl(this.content);
        this.element.setNamespace(qName.getNamespaceURI());
        this.element.setName(qName.getLocalPart());
        this.element.setAttributes(atts.toArray(new AttributeInstance[atts.size()]));
        this.node = new NodeImpl(this.element);
        for (i = 0; i < this.element.getAttributes().length; ++i) {
            AttributeInstance attribute = this.element.getAttributes()[i];
            ParseExecutor executor = new ParseExecutor(attribute, null, this.parent.getContext(), this.parser);
            this.parser.getBindingWalker().walk((XSDFeature)attribute.getAttributeDeclaration(), executor, this.parent.getContext());
            Object parsed = executor.getValue();
            this.node.addAttribute(new NodeImpl(attribute, parsed));
        }
        ElementInitializer initer = new ElementInitializer(this.element, this.node, this.parent.getContext());
        this.parser.getBindingWalker().walk((XSDFeature)this.element.getElementDeclaration(), initer, this.container(), this.parent.getContext());
        this.setContext((MutablePicoContainer)new DefaultPicoContainer((PicoContainer)this.parent.getContext()));
        ((BindingFactoryImpl)this.parser.getBindingFactory()).setContext(this.getContext());
        this.parent.startChildHandler(this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.element.addText(ch, start, length);
        if (this.isMixed()) {
            String text = new String(ch, start, length);
            this.node.addChild(new NodeImpl(TextInstance.INSTANCE, new Text(text)));
        }
    }

    @Override
    public void endElement(QName qName) throws SAXException {
        if (this.isMixed()) {
            this.node.collapseWhitespace();
        }
        if (this.isNil(this.element)) {
            this.value = null;
        } else {
            ParseExecutor executor = new ParseExecutor(this.element, this.node, this.getParentHandler().getContext(), this.parser);
            this.parser.getBindingWalker().walk((XSDFeature)this.element.getElementDeclaration(), executor, this.container(), this.getParentHandler().getContext());
            this.value = executor.getValue();
            if (this.value == null && this.parser.getLogger().isLoggable(Level.FINE)) {
                this.parser.getLogger().fine("Binding for " + this.element.getName() + " returned null");
            }
        }
        this.node.setValue(this.value);
        this.parent.endChildHandler(this);
        this.parent.getContext().removeChildContainer((PicoContainer)this.getContext());
    }

    private boolean isNil(ElementImpl element) {
        for (AttributeInstance att : element.getAttributes()) {
            if (!"nil".equals(att.getName()) || !"http://www.w3.org/2001/XMLSchema-instance".equals(att.getNamespace())) continue;
            return "true".equals(att.getText());
        }
        return false;
    }

    @Override
    public Handler createChildHandler(QName qName) {
        return this.getChildHandlerInternal(qName);
    }

    private Handler getChildHandlerInternal(QName qName) {
        QName subQName;
        Handler handler;
        XSDElementDeclaration sub;
        SchemaIndex index = this.parser.getSchemaIndex();
        XSDElementDeclaration element = index.getChildElement(this.content, qName);
        if (element != null) {
            ElementHandler handler2 = this.parser.getHandlerFactory().createElementHandler(element, (Handler)this, this.parser);
            return handler2;
        }
        element = index.getElementDeclaration(qName);
        if (element != null && (sub = element.getSubstitutionGroupAffiliation()) != null && (handler = this.getChildHandlerInternal(subQName = new QName(sub.getTargetNamespace(), sub.getName()))) != null) {
            handler = this.parser.getHandlerFactory().createElementHandler(element, (Handler)this, this.parser);
            return handler;
        }
        return null;
    }

    private XSDTypeDefinition container() {
        XSDTypeDefinition container = null;
        if (this.getParentHandler().getComponent() != null) {
            container = this.getParentHandler().getComponent().getTypeDefinition();
        }
        return container;
    }

    @Override
    public void startChildHandler(Handler child) {
        this.node.addChild(child.getParseNode());
        if (child instanceof ElementHandler) {
            ElementInstance childInstance = (ElementInstance)child.getComponent();
            ContextInitializer initer = new ContextInitializer(childInstance, this.node, child.getContext());
            this.parser.getBindingWalker().walk((XSDFeature)this.element.getElementDeclaration(), initer, this.container(), this.getContext());
        }
    }

    @Override
    public void endChildHandler(Handler child) {
    }

    @Override
    public Handler getParentHandler() {
        return this.parent;
    }

    @Override
    public XSDSchemaContent getSchemaContent() {
        return this.content;
    }

    @Override
    public Node getParseNode() {
        return this.node;
    }

    @Override
    public XSDElementDeclaration getElementDeclaration() {
        return this.content;
    }

    @Override
    public InstanceComponent getComponent() {
        return this.element;
    }

    public void setComponent(ElementImpl element) {
        this.element = element;
    }

    public Object getValue() {
        return this.value;
    }

    boolean isMixed() {
        if (!this.parser.isHandleMixedContent()) {
            return false;
        }
        return this.content.getType() != null && this.content.getType() instanceof XSDComplexTypeDefinition && ((XSDComplexTypeDefinition)this.content.getType()).isMixed();
    }

    public String toString() {
        return this.node != null ? this.node.toString() : "";
    }
}

