/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.junit.Assert;
import org.junit.Test;

public class XSNonPositiveIntegerStrategyTest
extends TestSchema {
    public void validateValues(String text, Number expected) throws Exception {
        BigInteger value = new BigInteger(text.trim());
        Object result = this.strategy.parse((InstanceComponent)this.element(text, this.qname), (Object)value);
        if (!(result instanceof BigInteger) && result instanceof Number) {
            result = BigInteger.valueOf(((Number)result).longValue());
        }
        Assert.assertEquals((Object)this.integer(expected), (Object)this.integer(result));
    }

    public BigInteger integer(Object value) {
        return value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(((Number)value).longValue());
    }

    public Number number(String number) {
        return BigInteger.valueOf(Long.parseLong(number));
    }

    @Test
    public void testNegativeOne() throws Exception {
        this.validateValues("-1", this.number("-1"));
    }

    @Test
    public void testZero() throws Exception {
        this.validateValues("0", this.number("0"));
    }

    @Test
    public void testLargePositiveNumber() throws Exception {
        try {
            this.validateValues("-12678967543233", new BigInteger("-12678967543233"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeNumber() throws Exception {
        this.validateValues("-100000", Integer.valueOf("-100000"));
    }

    @Override
    protected QName getQName() {
        return XS.NONPOSITIVEINTEGER;
    }
}

