/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xs.XSConfiguration;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;
import org.geotools.xsd.XSD;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class XSDateTimeStrategyTest
extends TestSchema {
    @Override
    protected QName getQName() {
        return null;
    }

    public void checkParseEncode(QName qname, String toParse, java.util.Date toEncode, String expectedEncoding) throws Exception {
        SimpleBinding strategy = (SimpleBinding)this.stratagy(qname);
        java.util.Date parsed = (java.util.Date)strategy.parse((InstanceComponent)this.element(toParse, qname), (Object)toParse);
        Assert.assertEquals(toEncode.getClass(), parsed.getClass());
        Assert.assertEquals((String)parsed.getClass().getName(), (Object)toEncode, (Object)parsed);
        String encoded = strategy.encode((Object)toEncode, null);
        Assert.assertEquals((Object)expectedEncoding, (Object)encoded);
    }

    private Calendar calendar(Integer ... values) {
        return this.calendar(TimeZone.getTimeZone("GMT"), values);
    }

    private Calendar calendar(TimeZone timeZone, Integer ... values) {
        int[] fields = new int[]{1, 2, 5, 11, 12, 13, 14};
        Calendar cal = Calendar.getInstance(timeZone);
        cal.clear();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            cal.set(fields[i], values[i]);
        }
        return cal;
    }

    private long timestamp(Integer ... values) {
        return this.timestamp(TimeZone.getTimeZone("GMT"), values);
    }

    private long timestamp(TimeZone timeZone, Integer ... values) {
        Calendar cal = this.calendar(timeZone, values);
        return cal.getTimeInMillis();
    }

    @Test
    public void testDate() throws Exception {
        Date expected = new Date(this.timestamp(2011, 9, 24));
        this.checkParseEncode(XS.DATE, "2011-10-24Z", expected, "2011-10-24Z");
    }

    @Test
    public void testTime() throws Exception {
        Object nil = null;
        Time expected = new Time(this.timestamp(new Integer[]{nil, nil, nil, 10, 53, 24}));
        this.checkParseEncode(XS.TIME, "10:53:24Z", expected, "10:53:24Z");
        expected = new Time(this.timestamp(TimeZone.getTimeZone("GMT-3:00"), nil, nil, nil, 10, 53, 24));
        this.checkParseEncode(XS.TIME, "10:53:24-03:00", expected, "13:53:24Z");
        expected = new Time(this.timestamp(TimeZone.getTimeZone("GMT+3:00"), nil, nil, nil, 10, 53, 24, 255));
        this.checkParseEncode(XS.TIME, "10:53:24.255+03:00", expected, "07:53:24.255Z");
    }

    @Test
    public void testTimeStamp() throws Exception {
        Timestamp expected = new Timestamp(this.timestamp(2011, 9, 24, 10, 53, 24));
        this.checkParseEncode(XS.DATETIME, "2011-10-24T10:53:24Z", expected, "2011-10-24T10:53:24Z");
        expected = new Timestamp(this.timestamp(2011, 9, 24, 10, 53, 24, 200));
        this.checkParseEncode(XS.DATETIME, "2011-10-24T10:53:24.200Z", expected, "2011-10-24T10:53:24.200Z");
        expected = new Timestamp(this.timestamp(TimeZone.getTimeZone("GMT+3:00"), 2011, 9, 24, 0, 0, 0, 200));
        this.checkParseEncode(XS.DATETIME, "2011-10-24T00:00:00.200+03:00", expected, "2011-10-23T21:00:00.200Z");
        expected = new Timestamp(this.timestamp(TimeZone.getTimeZone("GMT-3:00"), 2011, 9, 24, 0, 0, 0, 200));
        this.checkParseEncode(XS.DATETIME, "2011-10-24T00:00:00.200-03:00", expected, "2011-10-24T03:00:00.200Z");
        expected = new Timestamp(this.timestamp(2011, 9, 24, 10, 53, 0));
        this.checkParseEncode(XS.DATETIME, "2011-10-24T10:53Z", expected, "2011-10-24T10:53:00Z");
    }

    @Test
    public void testEncodeCalendarDate() throws Exception {
        Calendar cal = this.calendar(2011, 9, 24);
        this.testEncodeCalendar(cal, TEST.DATE, "2011-10-24Z");
        cal = this.calendar(TimeZone.getTimeZone("GMT+14:00"), 2011, 9, 24);
        this.testEncodeCalendar(cal, TEST.DATE, "2011-10-23Z");
    }

    @Test
    public void testEncodeCalendarTime() throws Exception {
        Object nil = null;
        Calendar cal = this.calendar(new Integer[]{nil, nil, nil, 10, 53, 31});
        this.testEncodeCalendar(cal, TEST.TIME, "10:53:31Z");
        cal = this.calendar(new Integer[]{nil, nil, nil, 10, 53, 31, 125});
        this.testEncodeCalendar(cal, TEST.TIME, "10:53:31.125Z");
    }

    @Test
    public void testEncodeCalendarDateTime() throws Exception {
        Calendar cal = this.calendar(2011, 9, 24, 10, 53, 31);
        this.testEncodeCalendar(cal, TEST.DATETIME, "2011-10-24T10:53:31Z");
        cal = this.calendar(2011, 9, 24, 10, 53, 31, 999);
        this.testEncodeCalendar(cal, TEST.DATETIME, "2011-10-24T10:53:31.999Z");
    }

    @Test
    public void testDirectlyEncodeCalendarDateTime() throws Exception {
        Calendar cal = this.calendar(2011, 9, 24, 10, 53, 31);
        String encoded = new XSDateTimeBinding().encode((Object)cal, null);
        Assert.assertEquals((Object)"2011-10-24T10:53:31Z", (Object)encoded);
        cal = this.calendar(2011, 9, 24, 10, 53, 31, 999);
        encoded = new XSDateTimeBinding().encode((Object)cal, null);
        Assert.assertEquals((Object)"2011-10-24T10:53:31.999Z", (Object)encoded);
    }

    @Test
    public void testParseEmptyStringAsNull() throws Exception {
        this.validateValues(XS.DATE, "", null);
        this.validateValues(XS.DATE, "\t", null);
        this.validateValues(XS.TIME, "", null);
        this.validateValues(XS.TIME, "\t", null);
        this.validateValues(XS.DATETIME, "", null);
        this.validateValues(XS.DATETIME, "\t", null);
    }

    public void validateValues(QName qname, String given, Object expected) throws Exception {
        SimpleBinding strategy = (SimpleBinding)this.stratagy(qname);
        Object result = strategy.parse((InstanceComponent)this.element(given, qname), (Object)given);
        super.validateValues(result, expected);
    }

    private void testEncodeCalendar(Calendar cal, QName qname, String expected) throws Exception {
        Encoder encoder = new Encoder((Configuration)new TestConfiguration());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        encoder.encode((Object)cal, qname, (OutputStream)out);
        Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(out.toByteArray()));
        String encodedValue = dom.getDocumentElement().getTextContent();
        Assert.assertEquals((Object)expected, (Object)encodedValue);
    }

    private static class TestConfiguration
    extends Configuration {
        public TestConfiguration() {
            super((XSD)new TEST());
            this.addDependency((Configuration)new XSConfiguration());
        }
    }

    private static class TEST
    extends XSD {
        public static final String NAMESPACE = "http://localhost/xob/test";
        public static final QName DATE = new QName("http://localhost/xob/test", "date");
        public static final QName TIME = new QName("http://localhost/xob/test", "time");
        public static final QName DATETIME = new QName("http://localhost/xob/test", "dateTime");

        private TEST() {
        }

        public String getNamespaceURI() {
            return NAMESPACE;
        }

        public String getSchemaLocation() {
            return TestSchema.url.toExternalForm();
        }
    }
}

