/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDNamedComponent;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ComplexBinding;
import org.geotools.xsd.impl.BindingWalker;

public class GetPropertyExecutor
implements BindingWalker.Visitor {
    static Logger LOGGER = Logging.getLogger(GetPropertyExecutor.class);
    Object parent;
    Object child;
    QName name;

    public GetPropertyExecutor(Object parent, XSDNamedComponent content) {
        this.parent = parent;
        this.name = new QName(content.getTargetNamespace(), content.getName());
    }

    public Object getChildObject() {
        return this.child;
    }

    @Override
    public void visit(Binding binding) {
        if (this.child != null) {
            return;
        }
        if (binding instanceof ComplexBinding) {
            Object parent;
            ComplexBinding complex = (ComplexBinding)binding;
            if (binding.getType() == null) {
                LOGGER.warning("Binding for: " + String.valueOf(binding.getTarget()) + " does not declare type");
            }
            if ((parent = this.parent) != null && binding.getType() != null && !binding.getType().isAssignableFrom(parent.getClass())) {
                LOGGER.fine(String.valueOf(parent) + " (" + parent.getClass().getName() + ")  is not of type " + binding.getType().getName());
                Object converted = Converters.convert((Object)parent, binding.getType());
                if (converted != null) {
                    parent = converted;
                } else {
                    LOGGER.fine("Could not convert " + String.valueOf(parent) + " to " + binding.getType().getName());
                    if (parent instanceof ComplexAttributeImpl) {
                        return;
                    }
                }
            }
            try {
                this.child = complex.getProperty(parent, this.name);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get property: " + String.valueOf(this.name), e);
            }
        }
    }
}

