/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.xs.TestSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.junit.Assert;
import org.junit.Test;

public class XSNegativeIntegerStrategyTest
extends TestSchema {
    public void validateValues(String text, Number expected) throws Exception {
        BigInteger value = new BigInteger(text.trim());
        Object result = this.strategy.parse((InstanceComponent)this.element(text, this.qname), (Object)value);
        if (!(result instanceof BigInteger) && result instanceof Number) {
            result = BigInteger.valueOf(((Number)result).longValue());
        }
        Assert.assertEquals((Object)this.integer(expected), (Object)this.integer(result));
    }

    public BigInteger integer(Object value) {
        return value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(((Number)value).longValue());
    }

    public Number number(String number) {
        return BigInteger.valueOf(Long.parseLong(number));
    }

    @Test
    public void testParse() throws Exception {
        this.validateValues("-1", new BigInteger("-1"));
        this.validateValues("-12678967543233", new BigInteger("-12678967543233"));
        this.validateValues("-100000", new BigInteger("-100000"));
    }

    @Override
    protected QName getQName() {
        return XS.NEGATIVEINTEGER;
    }
}

