/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Schemas;

public abstract class AbstractGenerator {
    static Logger logger = Logging.getLogger(AbstractGenerator.class);
    String packageBase;
    String sourceLocation;
    String testLocation;
    String resourceLocation;
    boolean overwriting = false;
    File schemaSourceDirectory;
    File[] schemaLookupDirectories;
    Set included = null;

    public void setPackageBase(String packageBase) {
        this.packageBase = packageBase;
    }

    public String getPackageBase() {
        return this.packageBase;
    }

    public void setSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public void setTestLocation(String testLocation) {
        this.testLocation = testLocation;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void setOverwriting(boolean overwriting) {
        this.overwriting = overwriting;
    }

    public void setSchemaSourceDirectory(File schemaSourceDirectory) {
        this.schemaSourceDirectory = schemaSourceDirectory;
    }

    public void setSchemaLookupDirectories(File[] schemaLookupDirectories) {
        this.schemaLookupDirectories = schemaLookupDirectories;
    }

    protected void write(String result, String className, String baseLocation) throws IOException {
        File location = this.outputLocation(baseLocation);
        location.mkdirs();
        location = new File(location, className + ".java");
        if (location.exists() && !this.overwriting) {
            logger.warning("Generated file: " + location + " already exists.");
            return;
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(location));
        if (this.packageBase != null) {
            out.write(("package " + this.packageBase + ";\n\n").getBytes());
        }
        out.write(result.getBytes());
        out.flush();
        out.close();
    }

    protected void copy(File file, String baseLocation) throws IOException {
        File dest = new File(this.outputLocation(baseLocation), file.getName());
        logger.info("Copying " + file + " to " + dest);
        if (dest.exists() && !this.overwriting) {
            logger.warning("Generated file: " + dest + " already exists.");
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        int b = -1;
        while ((b = ((InputStream)in).read()) != -1) {
            ((OutputStream)out).write(b);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    protected File findSchemaFile(String path) throws IOException {
        File file = null;
        try {
            file = new File(new URL(path).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            file = new File(path);
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (this.schemaSourceDirectory != null && (file = new File(this.schemaSourceDirectory, path)).exists()) {
            return file;
        }
        if (this.schemaLookupDirectories != null) {
            for (File dir : this.schemaLookupDirectories) {
                file = new File(dir, path);
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }

    protected File outputLocation(String baseLocation) {
        File location = null;
        if (baseLocation == null) {
            baseLocation = this.sourceLocation;
        }
        location = baseLocation != null ? new File(baseLocation) : new File(System.getProperty("user.dir"));
        if (this.packageBase != null) {
            String path = this.packageBase.replace('.', File.separatorChar);
            location = new File(location, path);
        }
        return location;
    }

    protected String execute(String templateName, Object input) throws ClassNotFoundException, RuntimeException {
        Class<?> c = Class.forName("org.geotools.maven.xmlcodegen.templates." + templateName);
        try {
            Object template = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method generate = c.getMethod("generate", Object.class);
            return (String)generate.invoke(template, input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String prefix(XSDSchema schema) {
        return Schemas.getTargetPrefix((XSDSchema)schema);
    }

    public void setIncluded(Set included) {
        this.included = included;
    }

    protected boolean included(XSDNamedComponent c) {
        return this.included != null ? this.included.contains(c.getName()) : true;
    }
}

