/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.xsd.Schemas;

public class GeneratorUtils {
    public static List allTypes(XSDSchema schema) {
        ArrayList types = new ArrayList(schema.getTypeDefinitions());
        ArrayList<Object> anonymous = new ArrayList<Object>();
        for (XSDElementDeclaration element : schema.getElementDeclarations()) {
            if (element.getAnonymousTypeDefinition() == null) continue;
            element.getAnonymousTypeDefinition().setName("_" + element.getName());
            anonymous.add(element.getAnonymousTypeDefinition());
        }
        for (XSDAttributeDeclaration attribute : schema.getAttributeDeclarations()) {
            if (attribute.getAnonymousTypeDefinition() == null) continue;
            attribute.getAnonymousTypeDefinition().setName("_" + attribute.getName());
            anonymous.add(attribute.getAnonymousTypeDefinition());
        }
        for (XSDTypeDefinition type : types) {
            List particles = Schemas.getChildElementParticles((XSDTypeDefinition)type, (boolean)false);
            for (Object o : particles) {
                XSDParticle particle = (XSDParticle)o;
                XSDElementDeclaration element = (XSDElementDeclaration)particle.getContent();
                if (element.isElementDeclarationReference() || element.getAnonymousTypeDefinition() == null) continue;
                element.getAnonymousTypeDefinition().setName(type.getName() + "_" + element.getName());
                anonymous.add(element.getAnonymousTypeDefinition());
            }
        }
        types.addAll(anonymous);
        return types;
    }

    public static List types(XSDSchema schema, Set names) {
        List allTypes = GeneratorUtils.allTypes(schema);
        if (names != null && !names.isEmpty()) {
            Iterator t = allTypes.iterator();
            while (t.hasNext()) {
                XSDTypeDefinition type = (XSDTypeDefinition)t.next();
                if (type.getName() != null && names.contains(type.getName())) continue;
                t.remove();
            }
        }
        return allTypes;
    }
}

