/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.maven.xmlcodegen.AbstractGenerator;
import org.geotools.maven.xmlcodegen.BindingConstructorArgument;
import org.geotools.maven.xmlcodegen.GeneratorUtils;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Schemas;

public class BindingGenerator
extends AbstractGenerator {
    static Logger logger = Logging.getLogger(BindingGenerator.class);
    boolean generateXsd = true;
    boolean generateAttributes = true;
    boolean generateElements = true;
    boolean generateTypes = true;
    boolean generateConfiguration = true;
    boolean generateTests = false;
    Class complexBindingBaseClass;
    Class simpleBindingBaseClass;
    BindingConstructorArgument[] bindingConstructorArguments;

    public void setBindingConstructorArguments(BindingConstructorArgument[] bindingConstructorArguments) {
        this.bindingConstructorArguments = bindingConstructorArguments;
    }

    public void setGenerateXsd(boolean generateXsd) {
        this.generateXsd = generateXsd;
    }

    public void setGenerateAttributes(boolean generateAttributes) {
        this.generateAttributes = generateAttributes;
    }

    public void setGenerateElements(boolean generateElements) {
        this.generateElements = generateElements;
    }

    public void setGenerateTypes(boolean generateTypes) {
        this.generateTypes = generateTypes;
    }

    public void setGenerateConfiguration(boolean generateConfiguration) {
        this.generateConfiguration = generateConfiguration;
    }

    public void setGenerateTests(boolean generateTests) {
        this.generateTests = generateTests;
    }

    public void setComplexBindingBaseClass(Class complexBindingBaseClass) {
        this.complexBindingBaseClass = complexBindingBaseClass;
    }

    public void setSimpleBindingBaseClass(Class simpleBindingBaseClass) {
        this.simpleBindingBaseClass = simpleBindingBaseClass;
    }

    public void generate(XSDSchema schema) {
        String prefix;
        String result;
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.generateElements) {
            EList elements = schema.getElementDeclarations();
            for (Object o : elements) {
                XSDElementDeclaration element = (XSDElementDeclaration)o;
                this.generate((XSDNamedComponent)element, schema);
                if (!this.target((XSDNamedComponent)element, schema)) continue;
                components.add(element);
            }
        }
        if (this.generateTypes) {
            List types = GeneratorUtils.allTypes(schema);
            for (Object o : types) {
                XSDTypeDefinition type = (XSDTypeDefinition)o;
                this.generate((XSDNamedComponent)type, schema);
                if (!this.target((XSDNamedComponent)type, schema)) continue;
                components.add(type);
            }
        }
        if (this.generateAttributes) {
            EList attributes = schema.getAttributeDeclarations();
            for (Object o : attributes) {
                XSDAttributeDeclaration attribute = (XSDAttributeDeclaration)o;
                this.generate((XSDNamedComponent)attribute, schema);
                if (!this.target((XSDNamedComponent)attribute, schema)) continue;
                components.add(attribute);
            }
        }
        if (this.generateXsd) {
            try {
                result = this.execute("XSDTemplate", schema);
                this.write(result, this.prefix(schema).toUpperCase(), this.sourceLocation);
            }
            catch (Exception e) {
                String msg = "Error generating binding interface";
                logger.log(Level.WARNING, msg, e);
            }
        }
        if (this.generateConfiguration) {
            try {
                result = this.execute("ConfigurationTemplate", new Object[]{schema, components});
                prefix = Schemas.getTargetPrefix((XSDSchema)schema).toUpperCase();
                this.write(result, prefix + "Configuration", this.sourceLocation);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error generating resolver", e);
            }
            ArrayList<File> includes = new ArrayList<File>();
            File file = null;
            try {
                file = this.findSchemaFile(schema.getSchemaLocation());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "", e);
            }
            if (file != null) {
                includes.add(file);
            } else {
                logger.log(Level.SEVERE, "Could not find: " + schema.getSchemaLocation() + " to copy.");
            }
            for (Object o : Schemas.getIncludes((XSDSchema)schema)) {
                XSDInclude include = (XSDInclude)o;
                file = null;
                try {
                    file = this.findSchemaFile(include.getSchemaLocation());
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "", e);
                }
                if (file != null) {
                    includes.add(file);
                    continue;
                }
                logger.log(Level.SEVERE, "Could not find: " + include.getSchemaLocation() + " to copy.");
            }
            for (File include : includes) {
                try {
                    this.copy(include, this.resourceLocation);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not copy file " + String.valueOf(include), e);
                }
            }
        }
        if (this.generateTests) {
            try {
                result = this.execute("BindingTestSupportClass", new Object[]{schema});
                prefix = Schemas.getTargetPrefix((XSDSchema)schema).toUpperCase();
                this.write(result, prefix + "TestSupport", this.testLocation);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error generating test support class", e);
            }
        }
    }

    boolean target(XSDNamedComponent c, XSDSchema schema) {
        return c.getTargetNamespace().equals(schema.getTargetNamespace());
    }

    void generate(XSDNamedComponent c, XSDSchema schema) {
        String msg;
        String result;
        if (!this.target(c, schema)) {
            return;
        }
        if (!this.included(c)) {
            return;
        }
        Class bindingBaseClass = this.simpleBindingBaseClass;
        if (c instanceof XSDComplexTypeDefinition) {
            bindingBaseClass = this.complexBindingBaseClass;
        }
        logger.info("Generating binding for " + c.getName());
        try {
            result = this.execute("CLASS", new Object[]{c, this.bindingConstructorArguments, bindingBaseClass});
            this.write(result, this.name(c), this.sourceLocation);
        }
        catch (Exception ioe) {
            msg = "Unable to generate binding for " + String.valueOf(c);
            logger.log(Level.WARNING, msg, ioe);
        }
        if (this.generateTests) {
            logger.info("Generating binding test for " + c.getName());
            try {
                result = this.execute("BindingTestClass", new Object[]{c});
                this.write(result, this.testName(c), this.testLocation);
            }
            catch (Exception ioe) {
                msg = "Unable to generate binding test for " + String.valueOf(c);
                logger.log(Level.WARNING, msg, ioe);
            }
        }
    }

    String name(XSDNamedComponent c) {
        return c.getName().substring(0, 1).toUpperCase() + c.getName().substring(1) + "Binding";
    }

    String testName(XSDNamedComponent c) {
        return c.getName().substring(0, 1).toUpperCase() + c.getName().substring(1) + "BindingTest";
    }

    public static void main(String[] args) throws Exception {
        XSDSchema schema = Schemas.parse((String)"/home/jdeolive/devel/geotools/trunk/demo/xml-po/src/main/xsd/po.xsd", null, null, null, null);
        System.out.println(schema.getQNamePrefixToNamespaceMap());
    }

    public static void usage() {
        System.out.println("Options");
        System.out.println("\t\t--help: Print this message");
        System.out.println("\t\t--schema <path>: Path to schema file");
        System.out.println("\t\t--output <path>: Path to output directory");
        System.out.println("\t\t--package <package>: Package out writen files");
        System.out.println("\t\t--include-type <type>: Include a single type");
        System.out.println("\t\t--carg <class>: Qualified class name of binding constructor argument");
        System.out.println("\t\t--noelements: Turn off element binding generation");
        System.out.println("\t\t--noattributes: Turn off attribute binding generation");
        System.out.println("\t\t--notypes: Turn off type binding generation");
        System.out.println("\t\t--no-binding-interface: Turn off binding interface generation");
        System.out.println("\t\t--no-binding-configuration: Turn off binding configuration generation");
    }
}

