/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.XSD;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected File schemaLocation;
    protected File schemaSourceDirectory;
    protected File[] schemaLookupDirectories;
    protected String destinationPackage;
    protected File outputDirectory;
    protected File sourceOutputDirectory;
    protected File testOutputDirectory;
    protected boolean overwriteExistingFiles;
    protected String[] includes;
    protected String targetPrefix;
    MavenProject project;
    ArtifactRepository localRepository;
    List remoteRepositories;
    ArtifactFactory artifactFactory;
    ArtifactResolver artifactResolver;
    ArtifactMetadataSource artifactMetadataSource;
    List classpathElements;
    boolean includeGML;
    boolean relativeSchemaReference;

    protected XSDSchema schema() {
        this.getLog().info((CharSequence)this.artifactFactory.toString());
        if (!this.schemaSourceDirectory.exists()) {
            this.getLog().error((CharSequence)(this.schemaSourceDirectory.getAbsolutePath() + " does not exist"));
            return null;
        }
        if (!this.schemaLocation.exists()) {
            this.schemaLocation = new File(this.schemaSourceDirectory, this.schemaLocation.getName());
            if (!this.schemaLocation.exists()) {
                this.getLog().error((CharSequence)("Could not locate schema: " + this.schemaLocation.getName()));
                return null;
            }
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.includeGML) {
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-gml2", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-gml3", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-filter", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-sld", "2.7-SNAPSHOT", "compile", "jar"));
        }
        HashSet<URL> urls = new HashSet<URL>();
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("Attempting to dynamically resolve: " + String.valueOf(artifact)));
            try {
                Set resolvedArtifacts = this.project.createArtifacts(this.artifactFactory, null, null);
                ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(resolvedArtifacts, artifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                resolvedArtifacts = result.getArtifacts();
                for (Object o : resolvedArtifacts) {
                    Artifact resolvedArtifact = (Artifact)o;
                    urls.add(resolvedArtifact.getFile().toURI().toURL());
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to resolve " + artifact.getId()), (Throwable)e);
            }
        }
        URLClassLoader ext = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        StringBuffer sb = new StringBuffer();
        sb.append("Using following classpath for XSD lookup: ");
        for (URL url : urls) {
            sb.append(url.toString());
        }
        this.getLog().debug((CharSequence)sb.toString());
        ArrayList<String> xsdNames = new ArrayList<String>();
        final ArrayList<XSD> xsds = new ArrayList<XSD>();
        xsdNames.add("org.geotools.xsd.XML");
        xsdNames.add("org.geotools.xlink.XLINK");
        if (this.includeGML) {
            xsdNames.add("org.geotools.gml2.GML");
            xsdNames.add("org.geotools.gml3.GML");
            xsdNames.add("org.geotools.filter.v1_0.OGC");
            xsdNames.add("org.geotools.filter.v1_1.OGC");
        }
        for (int i = 0; i < xsdNames.size(); ++i) {
            String className = (String)xsdNames.get(i);
            try {
                Class<?> clazz = ext.loadClass(className);
                Method m = clazz.getMethod("getInstance", null);
                XSD xsd = (XSD)m.invoke(null, null);
                xsds.add(xsd);
                continue;
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load " + className));
                this.getLog().debug((Throwable)e);
                xsdNames.set(i, null);
            }
        }
        XSDSchemaLocator locator = new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                for (XSD xsd : xsds) {
                    if (xsd == null || !xsd.getNamespaceURI().equals(namespaceURI)) continue;
                    try {
                        return xsd.getSchema();
                    }
                    catch (IOException e) {
                        AbstractGeneratorMojo.this.getLog().warn((CharSequence)("XSDSchemaLocator: Error occurred locating schema: " + namespaceURI), (Throwable)e);
                    }
                }
                AbstractGeneratorMojo.this.getLog().warn((CharSequence)("XSDSchemaLocator: Could not locate schema for: " + namespaceURI));
                return null;
            }
        };
        XSDSchemaLocationResolver locationResolver = new XSDSchemaLocationResolver(){

            public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String schemaLocation) {
                if (schemaLocation == null) {
                    AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Null location for " + namespaceURI));
                    return null;
                }
                File file = new File(schemaLocation);
                if (file.exists()) {
                    AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + schemaLocation));
                    return schemaLocation;
                }
                String fileName = new File(schemaLocation).getName();
                file = new File(AbstractGeneratorMojo.this.schemaSourceDirectory, fileName);
                if (file.exists()) {
                    AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + file.getAbsolutePath()));
                    return file.getAbsolutePath();
                }
                if (AbstractGeneratorMojo.this.schemaLookupDirectories != null) {
                    for (File schemaLookupDirectory : AbstractGeneratorMojo.this.schemaLookupDirectories) {
                        file = new File(schemaLookupDirectory, fileName);
                        if (!file.exists()) continue;
                        AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + file.getAbsolutePath()));
                        return file.getAbsolutePath();
                    }
                }
                AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Could not resolve location for: " + fileName));
                return null;
            }
        };
        XSDSchema xsdSchema = null;
        try {
            this.getLog().info((CharSequence)("Parsing schema: " + String.valueOf(this.schemaLocation)));
            xsdSchema = this.relativeSchemaReference ? Schemas.parse((String)this.schemaLocation.getAbsolutePath(), Collections.emptyList(), Collections.singletonList(new XSDSchemaLocationResolver(){

                public String resolveSchemaLocation(XSDSchema xsdSchema, String namespaceURI, String schemaLocationURI) {
                    try {
                        URI contextUri = new URI(xsdSchema.getSchemaLocation());
                        if (contextUri.isOpaque()) {
                            URL contextUrl = new URL(xsdSchema.getSchemaLocation());
                            return new URL(contextUrl, schemaLocationURI).toString();
                        }
                        return contextUri.resolve(schemaLocationURI).toString();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
            }), null, null) : Schemas.parse((String)this.schemaLocation.getAbsolutePath(), Collections.singletonList(locator), Collections.singletonList(locationResolver), null, null);
            if (xsdSchema == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to parse schema");
            this.getLog().error((Throwable)e);
            return null;
        }
        if (this.targetPrefix != null) {
            xsdSchema.getQNamePrefixToNamespaceMap().put(this.targetPrefix, xsdSchema.getTargetNamespace());
        }
        if (Schemas.getTargetPrefix((XSDSchema)xsdSchema) == null) {
            String msg = "Unable to determine a prefix for the target namespace of the schema Either  include a mapping in the schema or manually specify one with the 'targetPrefix' parameter.";
            throw new RuntimeException(msg);
        }
        return xsdSchema;
    }
}

