/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.teradata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.teradata.QueryBand;
import org.geotools.data.teradata.TeradataDataStoreFactory;
import org.geotools.data.teradata.TeradataFilterToSQL;
import org.geotools.data.teradata.TessellationInfo;
import org.geotools.data.teradata.WKBAttributeIO;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TeradataDialect
extends PreparedStatementSQLDialect {
    static final String SYSSPATIAL = "sysspatial";
    static final String TESSELLATION = "tessellation";
    static final String GEOMETRY_COLUMNS = "geometry_columns";
    static final String SPATIAL_REF_SYS = "spatial_ref_sys";
    static final String SPATIAL_INDEX = "org.geotools.data.teradata.spatialIndex";
    static final Map<String, Class<?>> TYPE_TO_CLASS = new HashMap<String, Class<?>>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("GEOSEQUENCE", Geometry.class);
        }
    };
    static final Map<Class<?>, String> CLASS_TO_TYPE = new HashMap<Class<?>, String>(){
        {
            this.put(Geometry.class, "GEOMETRY");
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINESTRING");
            this.put(Polygon.class, "POLYGON");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINESTRING");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
            this.put(GeometryCollection.class, "GEOMETRYCOLLECTION");
        }
    };
    boolean looseBBOXEnabled = false;
    boolean estimatedBounds = false;
    String application;
    int tdVersion = -1;
    private boolean lobWorkaroundEnabled;
    static Pattern ORDER_BY_QUERY = Pattern.compile(".*(ORDER BY (?:,? *\"?[\\w]+\"?(?: (?:ASC)|(:?DESC))?)+)");
    static Pattern ORDER_BY = Pattern.compile("ORDER BY (?:,? *\"?[\\w]+\"?(?: (?:ASC)|(:?DESC))?)+");

    public TeradataDialect(JDBCDataStore store) {
        super(store);
    }

    public boolean isLobWorkaroundEnabled() {
        return this.lobWorkaroundEnabled;
    }

    public void setLobWorkaroundEnabled(boolean lobWorkaroundEnabled) {
        this.lobWorkaroundEnabled = lobWorkaroundEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setEstimatedBounds(boolean estimatedBounds) {
        this.estimatedBounds = estimatedBounds;
    }

    public boolean isEstimatedBounds() {
        return this.estimatedBounds;
    }

    public int getTdVersion() {
        return this.tdVersion;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void initializeConnection(Connection cx) throws SQLException {
        if (this.tdVersion == -1) {
            this.tdVersion = cx.getMetaData().getDatabaseMajorVersion();
        }
        String sql = String.format("SET QUERY_BAND='%s;' FOR SESSION", QueryBand.APPLICATION + "=" + (this.application != null ? this.application : TeradataDataStoreFactory.APPLICATION.sample));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sql);
        }
        try (Statement st = cx.createStatement();){
            st.execute(sql);
        }
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.equalsIgnoreCase(GEOMETRY_COLUMNS)) {
            return false;
        }
        if (tableName.toLowerCase().startsWith(SPATIAL_REF_SYS)) {
            return false;
        }
        if (tableName.equalsIgnoreCase("geography_columns")) {
            return false;
        }
        if (tableName.equalsIgnoreCase(TESSELLATION)) {
            return false;
        }
        if (tableName.endsWith("_idx")) {
            return false;
        }
        return this.dataStore.getDatabaseSchema() == null || this.dataStore.getDatabaseSchema().equals(schemaName);
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g != null) {
            String wkt;
            if (g instanceof LinearRing) {
                g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
            }
            if ((wkt = new WKTWriter().write(g)).length() > 64000) {
                ByteArrayInputStream bin = new ByteArrayInputStream(wkt.getBytes());
                ps.setAsciiStream(column, (InputStream)bin, bin.available());
            } else {
                ps.setString(column, wkt);
            }
        } else {
            ps.setNull(column, 1111, "Geometry");
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        Geometry geometry;
        block15: {
            String wkt = null;
            try {
                wkt = rs.getString(column + "_inline");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (wkt != null) {
                return new WKTReader(factory).read(wkt);
            }
            int index = -1;
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                if (!column.equals(rs.getMetaData().getColumnName(i + 1))) continue;
                index = i + 1;
                break;
            }
            if ("java.lang.String".equals(rs.getMetaData().getColumnClassName(index))) {
                wkt = rs.getString(index);
                if (wkt == null) {
                    return null;
                }
                return new WKTReader(factory).read(wkt);
            }
            Clob clob = rs.getClob(column);
            if (clob == null) {
                return null;
            }
            InputStream in = clob.getAsciiStream();
            try {
                geometry = new WKTReader(factory).read((Reader)new InputStreamReader(in));
                if (in == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException e) {
                    throw (IOException)new IOException("Error parsing geometry").initCause(e);
                }
            }
            in.close();
        }
        return geometry;
    }

    WKBAttributeIO getWkbReader(GeometryFactory factory) {
        factory = factory != null ? factory : this.dataStore.getGeometryFactory();
        return new WKBAttributeIO(factory);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry envelope = this.getWkbReader(null).read(rs, column);
        if (envelope != null) {
            return envelope.getEnvelopeInternal();
        }
        return new Envelope();
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        if ("DECIMAL".equals(sqlTypeName)) {
            sql.append(sqlTypeName).append("(10,2)");
        } else {
            super.encodeColumnType(sqlTypeName, sql);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(".ST_Envelope().ST_AsBinary()");
    }

    public void encodePostSelect(SimpleFeatureType featureType, StringBuffer sql) {
        if (this.tdVersion > 12 && this.lobWorkaroundEnabled) {
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                if (!(att instanceof GeometryDescriptor)) continue;
                sql.append(", CASE WHEN CHARACTERS(cast(");
                this.encodeColumnName(null, att.getLocalName(), sql);
                sql.append(" as clob)) > 30000 THEN NULL ELSE CAST (");
                this.encodeColumnName(null, att.getLocalName(), sql);
                sql.append(" as VARCHAR(30000)) END");
                this.encodeColumnAlias(att.getLocalName() + "_inline", sql);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        List<TessellationInfo> tinfos;
        block16: {
            if (!this.estimatedBounds) {
                return null;
            }
            String tableName = featureType.getTypeName();
            if (this.tdVersion > 12) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT gc.UxMin, gc.UyMin, gc.UxMax, gc.UyMax, srs.AUTH_SRID FROM ");
                this.encodeTableName(SYSSPATIAL, GEOMETRY_COLUMNS, sql);
                this.encodeTableAlias("gc", sql);
                sql.append(", ");
                this.encodeTableName(SYSSPATIAL, SPATIAL_REF_SYS, sql);
                this.encodeTableAlias("srs", sql);
                sql.append(" WHERE ");
                sql.append("gc.");
                this.encodeColumnName(null, "SRID", sql);
                sql.append(" = ");
                sql.append("srs.");
                this.encodeColumnName(null, "SRID", sql);
                sql.append(" AND gc.");
                this.encodeColumnName(null, "F_TABLE_SCHEMA", sql);
                sql.append(" = ?").append(" AND ");
                sql.append("gc.");
                this.encodeColumnName(null, "F_TABLE_NAME", sql);
                sql.append(" = ? ");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("%s;1=%s;2=%s", sql.toString(), schema, tableName));
                }
                PreparedStatement ps = cx.prepareStatement(sql.toString());
                try {
                    ArrayList<ReferencedEnvelope> srid2;
                    ps.setString(1, schema);
                    ps.setString(2, tableName);
                    ResultSet rs = null;
                    try {
                        rs = ps.executeQuery();
                        ArrayList<ReferencedEnvelope> envs = new ArrayList<ReferencedEnvelope>();
                        if (rs.next()) {
                            int srid2 = rs.getInt(5);
                            ReferencedEnvelope env = new ReferencedEnvelope(rs.getDouble(1), rs.getDouble(3), rs.getDouble(2), rs.getDouble(4), CRS.decode((String)("EPSG:" + srid2)));
                            if (env.isEmpty() || env.isNull() || env.getWidth() == 0.0 && env.getMinX() == 0.0) {
                                throw new Exception("Empty universe in geometry columns");
                            }
                            envs.add(env);
                        }
                        srid2 = envs;
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.log(Level.FINER, "Error query geometry_columns", e);
                            break block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.dataStore.closeSafe(rs);
                        }
                    }
                    this.dataStore.closeSafe(rs);
                    return srid2;
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
            }
        }
        if ((tinfos = this.lookupTessellationInfos(cx, schema, featureType.getTypeName(), null)).isEmpty()) {
            return null;
        }
        ArrayList<ReferencedEnvelope> envs = new ArrayList<ReferencedEnvelope>();
        for (TessellationInfo tinfo : tinfos) {
            GeometryDescriptor gatt = (GeometryDescriptor)featureType.getDescriptor(tinfo.getColumName());
            ReferencedEnvelope env = new ReferencedEnvelope(gatt.getCoordinateReferenceSystem());
            env.init(tinfo.getUBounds());
            envs.add(env);
        }
        return envs;
    }

    public boolean isAutoCommitQuery() {
        return true;
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" PRIMARY KEY not null integer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ref.AUTH_SRID FROM ");
        this.encodeTableName(SYSSPATIAL, SPATIAL_REF_SYS, sql);
        sql.append(" as ref, ");
        this.encodeTableName(SYSSPATIAL, GEOMETRY_COLUMNS, sql);
        sql.append(" as col ");
        sql.append(" WHERE col.F_TABLE_SCHEMA = ?");
        sql.append(" AND col.F_TABLE_NAME = ? ");
        sql.append(" AND col.F_GEOMETRY_COLUMN = ? ");
        sql.append(" AND col.SRID = ref.SRID");
        LOGGER.log(Level.FINE, String.format("%s; 1=%s, 2=%s, 3=%s", sql.toString(), schemaName, tableName, columnName));
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        try {
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ps.setString(3, columnName);
            ResultSet rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
                LOGGER.warning(String.format("No SRID entry for %s, %s, %s", schemaName, tableName, columnName));
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
        return null;
    }

    public String getGeometryTypeName(Integer type) {
        return "ST_Geometry";
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String typeName = columnMetaData.getString("TYPE_NAME");
        String gType = null;
        if (!"SYSUDTLIB.ST_GEOMETRY".equalsIgnoreCase(typeName)) {
            return null;
        }
        gType = this.lookupGeometryType(columnMetaData, cx);
        if (gType == null) {
            return Geometry.class;
        }
        Class<Object> geometryClass = TYPE_TO_CLASS.get(gType.toUpperCase());
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT TOP 1 ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" FROM ");
        this.encodeTableName(schemaName, tableName, sql);
        sql.append(" ORDER BY ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" DESC");
        LOGGER.fine(sql.toString());
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        try {
            ResultSet rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lookupGeometryType(ResultSet columnMetaData, Connection cx) throws SQLException {
        String schemaName = columnMetaData.getString("TABLE_SCHEM");
        String tableName = columnMetaData.getString("TABLE_NAME");
        String columnName = columnMetaData.getString("COLUMN_NAME");
        StringBuffer sql = new StringBuffer("SELECT GEOM_TYPE");
        sql.append(" FROM ");
        this.encodeTableName(SYSSPATIAL, GEOMETRY_COLUMNS, sql);
        sql.append("WHERE F_TABLE_SCHEMA = ? AND F_TABLE_NAME = ? AND F_GEOMETRY_COLUMN = ?");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("%s; 1=%s, 2=%s, 3=%s", sql.toString(), schemaName, tableName, columnName));
        }
        PreparedStatement ps = cx.prepareStatement(sql.toString());
        try {
            ps.setString(1, schemaName);
            ps.setString(2, tableName);
            ps.setString(3, columnName);
            ResultSet rs = ps.executeQuery();
            try {
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
        return null;
    }

    TessellationInfo lookupTessellationInfo(Connection cx, String schemaName, String tableName, String columnName) throws SQLException {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name must not be null");
        }
        List<TessellationInfo> tinfos = this.lookupTessellationInfos(cx, schemaName, tableName, columnName);
        return !tinfos.isEmpty() ? tinfos.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<TessellationInfo> lookupTessellationInfos(Connection cx, String schemaName, String tableName, String columnName) throws SQLException {
        ArrayList<TessellationInfo> tinfos;
        block17: {
            DatabaseMetaData metadata = cx.getMetaData();
            ResultSet tables = metadata.getTables(null, this.dataStore.escapeNamePattern(metadata, SYSSPATIAL), this.dataStore.escapeNamePattern(metadata, TESSELLATION), new String[]{"TABLE"});
            try {
                if (!tables.next()) {
                    LOGGER.warning("sysspatial.tessellation does not exist. Unable to  perform spatially index queries.");
                    List<TessellationInfo> list = Collections.emptyList();
                    return list;
                }
            }
            finally {
                this.dataStore.closeSafe(tables);
            }
            tinfos = new ArrayList<TessellationInfo>();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM ");
            this.encodeTableName(SYSSPATIAL, TESSELLATION, sql);
            sql.append(" WHERE ");
            this.encodeColumnName(null, "F_TABLE_SCHEMA", sql);
            sql.append(" = ?").append(" AND ");
            this.encodeColumnName(null, "F_TABLE_NAME", sql);
            sql.append(" = ?");
            if (columnName != null) {
                sql.append(" AND ");
                this.encodeColumnName(null, "F_GEOMETRY_COLUMN", sql);
                sql.append(" = ?");
            }
            LOGGER.fine(sql.toString());
            PreparedStatement ps = cx.prepareStatement(sql.toString());
            try {
                ps.setString(1, schemaName);
                ps.setString(2, tableName);
                if (columnName != null) {
                    ps.setString(3, columnName);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) break block17;
                    TessellationInfo tinfo = new TessellationInfo();
                    tinfo.setUBounds(new Envelope(rs.getDouble("U_XMIN"), rs.getDouble("U_XMAX"), rs.getDouble("U_YMIN"), rs.getDouble("U_YMAX")));
                    tinfo.setNx(rs.getInt("G_NX"));
                    tinfo.setNy(rs.getInt("G_NY"));
                    tinfo.setLevels(rs.getInt("LEVELS"));
                    tinfo.setScale(rs.getDouble("SCALE"));
                    tinfo.setShift(rs.getInt("SHIFT"));
                    tinfo.setColumName(rs.getString("F_GEOMETRY_COLUMN"));
                    tinfo.setSchemaName(schemaName);
                    tinfo.setTableName(tableName);
                    tables = metadata.getTables(null, this.dataStore.escapeNamePattern(metadata, schemaName), this.dataStore.escapeNamePattern(metadata, tableName + "_" + columnName + "_idx"), new String[]{"TABLE", "VIEW"});
                    try {
                        if (tables.next()) {
                            tinfo.setIndexTableName(tables.getString("TABLE_NAME"));
                        }
                    }
                    finally {
                        this.dataStore.closeSafe(tables);
                    }
                    tinfos.add(tinfo);
                }
                finally {
                    this.dataStore.closeSafe(rs);
                }
            }
            finally {
                this.dataStore.closeSafe((Statement)ps);
            }
        }
        return tinfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupSqlTypeName(Connection cx, String schemaName, String tableName, String columnName) throws SQLException {
        String string;
        ResultSet columns = null;
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            columns = metaData.getColumns(null, this.dataStore.escapeNamePattern(metaData, schemaName), this.dataStore.escapeNamePattern(metaData, tableName), this.dataStore.escapeNamePattern(metaData, columnName));
            if (!columns.next()) {
                throw new SQLException("Could not find column metadata");
            }
            string = columns.getString("TYPE_NAME");
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(columns);
            throw throwable;
        }
        this.dataStore.closeSafe(columns);
        return string;
    }

    void encodeTableName(String schemaName, String tableName, StringBuffer sql) {
        if (schemaName != null && !"".equals(schemaName.trim())) {
            this.encodeSchemaName(schemaName, sql);
            sql.append(".");
        }
        this.encodeTableName(tableName, sql);
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
        if (att instanceof GeometryDescriptor) {
            TessellationInfo tinfo = this.lookupTessellationInfo(cx, schemaName, tableName, att.getLocalName());
            if (tinfo != null) {
                att.getUserData().put(TessellationInfo.KEY, tinfo);
            } else {
                LOGGER.fine(String.format("%s.%s.(%s) does not have tessellation entry.", schemaName, tableName, att.getLocalName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        String tableName = featureType.getName().getLocalPart();
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String geomType;
            if (!(att instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)att;
            int srid = 0;
            Integer epsg = null;
            if (gd.getCoordinateReferenceSystem() != null) {
                try {
                    epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error looking up epsg code", e);
                }
            }
            if (epsg != null) {
                String sql = "SELECT SRID FROM SYSSPATIAL.spatial_ref_sys WHERE AUTH_SRID = ?";
                LOGGER.log(Level.FINE, sql + ";{0}", epsg);
                PreparedStatement ps = cx.prepareStatement(sql);
                try {
                    ps.setInt(1, epsg);
                    ResultSet rs = ps.executeQuery();
                    try {
                        if (rs.next()) {
                            srid = rs.getInt("SRID");
                        } else {
                            LOGGER.warning("EPSG Code " + epsg + " does not map to SRID");
                        }
                    }
                    finally {
                        this.dataStore.closeSafe(rs);
                    }
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
            }
            geomType = (geomType = CLASS_TO_TYPE.get(gd.getType().getBinding())) != null ? geomType : "GEOMETRY";
            String sql = "INSERT INTO SYSSPATIAL.GEOMETRY_COLUMNS (F_TABLE_CATALOG, F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, COORD_DIMENSION, SRID, GEOM_TYPE) VALUES (?, ?, ?, ?, 2, ?, ?)";
            LOGGER.log(Level.FINE, sql + ";{0},{1},{2},{3},{4},{5}", new Object[]{"", schemaName, tableName, gd.getLocalName(), srid, geomType});
            PreparedStatement ps = cx.prepareStatement(sql);
            try {
                ps.setString(1, "");
                ps.setString(2, schemaName);
                ps.setString(3, tableName);
                ps.setString(4, gd.getLocalName());
                ps.setInt(5, srid);
                ps.setString(6, geomType);
                ps.execute();
            }
            finally {
                this.dataStore.closeSafe((Statement)ps);
            }
            PrimaryKey pkey = this.dataStore.getPrimaryKeyFinder().getPrimaryKey(this.dataStore, schemaName, tableName, cx);
            if (!(pkey instanceof NullPrimaryKey)) {
                String indexTableName = tableName + "_" + gd.getLocalName() + "_idx";
                String hashIndex = indexTableName + "_idx";
                StringBuffer sb = new StringBuffer("DROP HASH INDEX ");
                this.encodeTableName(schemaName, hashIndex, sb);
                sql = sb.toString();
                LOGGER.fine(sql);
                try {
                    ps = cx.prepareStatement(sql);
                    ps.execute();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
                sb = new StringBuffer("DROP TABLE ");
                this.encodeTableName(schemaName, indexTableName, sb);
                sql = sb.toString();
                LOGGER.fine(sql);
                try {
                    ps = cx.prepareStatement(sql);
                    ps.execute();
                }
                catch (SQLException sQLException) {
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
                sb = new StringBuffer("CREATE MULTISET TABLE ");
                this.encodeTableName(schemaName, indexTableName, sb);
                sb.append("( ");
                for (PrimaryKeyColumn col : pkey.getColumns()) {
                    this.encodeColumnName(null, col.getName(), sb);
                    String typeName = this.lookupSqlTypeName(cx, schemaName, tableName, col.getName());
                    sb.append(" ").append(typeName).append(" NOT NULL, ");
                }
                if (!pkey.getColumns().isEmpty()) {
                    sb.append("cellid INTEGER NOT NULL)");
                    sb.append("PRIMARY INDEX (");
                    this.encodeColumnName(null, ((PrimaryKeyColumn)pkey.getColumns().get(0)).getName(), sb);
                    sb.append(")");
                }
                sql = sb.toString();
                LOGGER.fine(sql);
                try {
                    ps = cx.prepareStatement(sql);
                    ps.execute();
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
                sb = new StringBuffer("CREATE HASH INDEX " + hashIndex + " (cellid) ON " + indexTableName + " ORDER BY (cellid)");
                sql = sb.toString();
                LOGGER.fine(sql);
                try {
                    ps = cx.prepareStatement(sql);
                    ps.execute();
                }
                finally {
                    this.dataStore.closeSafe((Statement)ps);
                }
                this.installTriggers(cx, tableName, gd.getLocalName(), indexTableName, pkey.getColumns());
                continue;
            }
            LOGGER.warning("No primary key for " + schemaName + "." + tableName + ". Unable to create spatial index.");
        }
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("ST_GEOMETRY", Geometry.class);
        mappings.put("SYSUDTLIB.ST_GEOMETRY", Geometry.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(12, "VARCHAR");
        overrides.put(8, "FLOAT");
        overrides.put(2, "DECIMAL");
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (offset == 0) {
            int i = sql.indexOf("SELECT");
            sql.insert(i + 6, " TOP " + limit);
        } else {
            Matcher m = ORDER_BY_QUERY.matcher(sql.toString());
            String orderBy = null;
            if (m.matches()) {
                orderBy = m.group(1);
                m = ORDER_BY.matcher(sql.toString());
                String s = m.replaceAll("");
                sql.setLength(0);
                sql.append(s);
            }
            sql.insert(0, "SELECT t.*, ROW_NUMBER() OVER (ORDER BY 'foo') AS row_num FROM (");
            sql.append(") AS t ");
            if (orderBy != null) {
                sql.append(orderBy).append(" ");
            }
            long max = limit == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)(limit + offset);
            sql.append("QUALIFY row_num > ").append(offset).append(" AND row_num <= ").append(max);
        }
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        return new TeradataFilterToSQL(this);
    }

    public void onSelect(PreparedStatement select, Connection cx, SimpleFeatureType featureType) throws SQLException {
        this.setQueryBand(cx, "SELECT");
    }

    public void onDelete(PreparedStatement delete, Connection cx, SimpleFeatureType featureType) throws SQLException {
        this.setQueryBand(cx, "DELETE");
    }

    public void onInsert(PreparedStatement insert, Connection cx, SimpleFeatureType featureType) throws SQLException {
        this.setQueryBand(cx, "INSERT");
    }

    public void onUpdate(PreparedStatement update, Connection cx, SimpleFeatureType featureType) throws SQLException {
        this.setQueryBand(cx, "UPDATE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQueryBand(Connection cx, String process) throws SQLException {
        String sql = "SET QUERY_BAND=? FOR TRANSACTION";
        StringBuffer qb = new StringBuffer();
        for (Map.Entry<String, String> e : QueryBand.local().entrySet()) {
            qb.append(e.getKey()).append("=").append(e.getValue()).append(";");
        }
        qb.append(QueryBand.PROCESS).append("=").append(process).append(";");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("%s;1=%s", sql, qb.toString()));
        }
        PreparedStatement ps = cx.prepareStatement(sql);
        try {
            ps.setString(1, qb.toString());
            ps.execute();
        }
        finally {
            this.dataStore.closeSafe((Statement)ps);
        }
    }

    private void encodeWhereStatement(StringBuffer buf, List<PrimaryKeyColumn> ids, String table) {
        buf.append(" WHERE ");
        for (int i = 0; i < ids.size(); ++i) {
            this.encodeColumnName(null, ids.get(i).getName(), buf);
            buf.append('=');
            buf.append(table).append('.');
            this.encodeColumnName(null, ids.get(i).getName(), buf);
            if (i + 1 >= ids.size()) continue;
            buf.append(" AND ");
        }
        buf.append(" ");
    }

    private void installInsertTrigger(Connection cx, String tableName, String geomName, String indexTableName, List<PrimaryKeyColumn> primaryKeys) throws SQLException {
        String referencing = "REFERENCING NEW TABLE AS nt";
        String triggerAction = "INSERT";
        String triggerStmt = this.createTriggerInsert(indexTableName, geomName, primaryKeys);
        this.installTrigger(cx, tableName, geomName, triggerAction, referencing, triggerStmt);
    }

    private void installUpdateTrigger(Connection cx, String tableName, String geomName, String indexTableName, List<PrimaryKeyColumn> primaryKeys) throws SQLException {
        String referencing = "REFERENCING NEW TABLE AS nt";
        String triggerAction = "UPDATE";
        StringBuffer buf = new StringBuffer("DELETE FROM " + indexTableName);
        this.encodeWhereStatement(buf, primaryKeys, "nt");
        buf.append(';');
        buf.append(this.createTriggerInsert(indexTableName, geomName, primaryKeys));
        this.installTrigger(cx, tableName, geomName, triggerAction, referencing, buf.toString());
    }

    private void installDeleteTrigger(Connection cx, String tableName, String geomName, String indexTableName, List<PrimaryKeyColumn> primaryKeys) throws SQLException {
        String referencing = "REFERENCING OLD TABLE AS ot";
        String triggerAction = "DELETE";
        StringBuffer buf = new StringBuffer("DELETE FROM " + indexTableName);
        this.encodeWhereStatement(buf, primaryKeys, "ot");
        buf.append(';');
        this.installTrigger(cx, tableName, geomName, triggerAction, referencing, buf.toString());
    }

    private String createTriggerInsert(String indexTable, String geometryName, List<PrimaryKeyColumn> primaryKeys) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            this.encodeColumnName(null, primaryKeys.get(i).getName(), buf);
            if (i + 1 >= primaryKeys.size()) continue;
            buf.append(',');
        }
        String tinsert = "INSERT INTO {0} SELECT " + buf.toString() + ",      sysspatial.tessellate_index(      \"{1}\".ST_MBR().Xmin(),       \"{1}\".ST_MBR().Ymin(),       \"{1}\".ST_MBR().Xmax(),       \"{1}\".ST_MBR().Ymax(),       {2,number,0.0#}, {3,number,0.0#}, {4,number,0.0#}, {5,number,0.0#},       {6,number,0}, {7,number,0}, {8,number,0}, {9,number,0.0#}, {10,number,0}) from nt WHERE {1} IS NOT NULL;";
        int west = -180;
        int south = -90;
        int east = 180;
        int north = 90;
        int nx = 1000;
        int ny = 1000;
        int level = 3;
        double scale = 0.01;
        int shift = 0;
        return MessageFormat.format(tinsert, indexTable, geometryName, west, south, east, north, nx, ny, level, scale, shift);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installTrigger(Connection cx, String tableName, String geomName, String triggerAction, String referencing, String triggerStmt) throws SQLException {
        String triggerName = tableName + "_" + geomName + "_m" + triggerAction.substring(0, 1).toLowerCase();
        String sql = "CREATE TRIGGER " + triggerName + " AFTER " + triggerAction + " ON " + tableName + "\n";
        sql = sql + referencing + "\n";
        sql = sql + "FOR EACH STATEMENT BEGIN ATOMIC (\n";
        sql = sql + triggerStmt + "\n) END;";
        Statement s = cx.createStatement();
        try {
            LOGGER.fine("trigger SQL : " + sql);
            s.execute(sql);
        }
        finally {
            this.dataStore.closeSafe(s);
        }
    }

    void installTriggers(Connection cx, String tableName, String geomName, String indexTableName, List<PrimaryKeyColumn> primaryKeys) throws SQLException {
        this.installInsertTrigger(cx, tableName, geomName, indexTableName, primaryKeys);
        this.installUpdateTrigger(cx, tableName, geomName, indexTableName, primaryKeys);
        this.installDeleteTrigger(cx, tableName, geomName, indexTableName, primaryKeys);
        LOGGER.info("Installed triggers on " + tableName + " to update " + indexTableName);
    }
}

