/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import org.locationtech.jts.io.InStream;

public class VarintDataInStream {
    InStream stream;
    private byte[] buf1 = new byte[1];

    public VarintDataInStream() {
    }

    public VarintDataInStream(InStream stream) {
        this.stream = stream;
    }

    public void setInStream(InStream stream) {
        this.stream = stream;
    }

    public byte readByte() throws IOException {
        this.stream.read(this.buf1);
        return this.buf1[0];
    }

    public int readUnsignedInt() throws IOException {
        int shift;
        this.stream.read(this.buf1);
        byte b = this.buf1[0];
        if ((b & 0x80) == 0) {
            return b;
        }
        int val = b & 0x7F;
        for (shift = 7; shift < 32; shift += 7) {
            this.stream.read(this.buf1);
            b = this.buf1[0];
            val |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return val;
        }
        while (shift < 64) {
            this.stream.read(this.buf1);
            b = this.buf1[0];
            if ((b & 0x80) == 0) {
                return val;
            }
            shift += 7;
        }
        throw new IllegalArgumentException("Invalid varint found, used more than 64 bits");
    }

    public int readSignedInt() throws IOException {
        int val = this.readUnsignedInt();
        return this.unzigzag(val);
    }

    private int unzigzag(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    long readUnsignedLong() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            this.stream.read(this.buf1);
            byte b = this.buf1[0];
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("Invalid varint found, used more than 64 bits");
    }

    public long readSignedLong() throws IOException {
        long val = this.readUnsignedLong();
        return this.unzigzagLong(val);
    }

    private long unzigzagLong(long n) {
        return n >>> 1 ^ -(n & 1L);
    }
}

