/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import java.util.Date;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.BigDate;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.JsonArrayContainsFunction;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;

public class PostgisFilterToSQL
extends FilterToSQL {
    FilterToSqlHelper helper = new FilterToSqlHelper(this);
    private boolean functionEncodingEnabled;
    protected PostGISDialect pgDialect;

    public PostgisFilterToSQL(PostGISDialect dialect) {
        this.pgDialect = dialect;
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        return this.helper.encodeBBOXFilterAsEnvelope;
    }

    public void setEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        this.helper.encodeBBOXFilterAsEnvelope = encodeBBOXFilterAsEnvelope;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Object typename;
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (geom instanceof LinearRing) {
            geom = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
        }
        Object v0 = typename = this.currentGeometry != null ? this.currentGeometry.getUserData().get("org.geotools.jdbc.nativeTypeName") : null;
        if ("geography".equals(typename)) {
            this.out.write("ST_GeogFromText('");
            this.out.write(geom.toText());
            this.out.write("')");
        } else {
            this.out.write("ST_GeomFromText('");
            this.out.write(geom.toText());
            if (this.currentSRID == null && this.currentGeometry != null) {
                this.out.write("', ST_SRID(" + this.escapeName(this.currentGeometry.getLocalName()) + "))");
            } else {
                this.out.write("', " + this.currentSRID + ")");
            }
        }
    }

    protected FilterCapabilities createFilterCapabilities() {
        return FilterToSqlHelper.createFilterCapabilities(this.functionEncodingEnabled);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    GeometryDescriptor getCurrentGeometry() {
        return this.currentGeometry;
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        this.helper.out = this.out;
        try {
            this.encodingFunction = true;
            boolean encoded = this.helper.visitFunction(function, extraData);
            this.encodingFunction = false;
            if (encoded) {
                return extraData;
            }
            return super.visit(function, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(Literal literal, Object extraData) {
        if (extraData instanceof Class && BigDate.class.isAssignableFrom((Class)extraData) && literal.getValue() instanceof Date) {
            return super.visit(filterFactory.literal(((Date)literal.getValue()).getTime()), Long.class);
        }
        return super.visit(literal, extraData);
    }

    protected String getFunctionName(Function function) {
        return this.helper.getFunctionName(function);
    }

    protected String cast(String encodedProperty, Class target) throws IOException {
        return this.helper.cast(encodedProperty, target);
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    public double getDistanceInNativeUnits(DistanceBufferOperator operator) {
        return super.getDistanceInNativeUnits(operator);
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class rightContext = super.getExpressionType(left);
        Class leftContext = super.getExpressionType(right);
        String type = (String)extraData;
        if ((this.helper.isArray(rightContext) || this.helper.isArray(leftContext)) && (left instanceof PropertyName || right instanceof PropertyName)) {
            this.helper.out = this.out;
            this.helper.visitArrayComparison(filter, left, right, rightContext, leftContext, type);
        } else if (left instanceof JsonPointerFunction || right instanceof JsonPointerFunction) {
            rightContext = this.getExpressionTypeIncludingLiterals(left);
            leftContext = this.getExpressionTypeIncludingLiterals(right);
            super.encodeBinaryComparisonOperator(filter, extraData, left, right, leftContext, rightContext);
        } else {
            super.visitBinaryComparisonOperator(filter, extraData);
        }
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Class context = super.getExpressionType(expr);
        if (this.helper.isArray(context)) {
            this.helper.out = this.out;
            this.helper.visitArrayBetween(filter, context.getComponentType(), extraData);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        this.helper.out = this.out;
        if (left instanceof JsonArrayContainsFunction || right instanceof JsonArrayContainsFunction) {
            Class leftContext = super.getExpressionType(left);
            try {
                this.writeBinaryExpression(left, leftContext);
            }
            catch (IOException ioe) {
                throw new RuntimeException("io problem writing filter", ioe);
            }
            return extraData;
        }
        if (this.helper.isSupportedEqualFunction(filter)) {
            return this.helper.visitSupportedEqualFunction(filter, (SQLDialect)this.pgDialect, (a, b) -> {
                try {
                    this.pgDialect.encodeGeometryValue((Geometry)a, this.helper.getFeatureTypeGeometryDimension(), this.helper.getFeatureTypeGeometrySRID(), (StringBuffer)b);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, extraData);
        }
        return super.visit(filter, extraData);
    }

    private Class getExpressionTypeIncludingLiterals(Expression expression) {
        Class<?> result = super.getExpressionType(expression);
        if (expression instanceof Literal) {
            result = ((Literal)expression).getValue().getClass();
        }
        return result;
    }
}

