/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.lang.reflect.Method;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class OracleNClobConverterFactory
implements ConverterFactory {
    OracleNClobConverter converter = new OracleNClobConverter();
    static final Class<?> ORA_NCLOB;
    static final Method ORA_GET_CHARS;
    static final Method ORA_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ORA_NCLOB == null) {
            return null;
        }
        if (!String.class.equals(target)) {
            return null;
        }
        if (!ORA_NCLOB.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> oracleClobClass = null;
        try {
            oracleClobClass = Class.forName("oracle.sql.NCLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (oracleClobClass == null) {
            ORA_NCLOB = null;
            ORA_GET_CHARS = null;
            ORA_LENGTH = null;
        } else {
            try {
                ORA_NCLOB = oracleClobClass;
                ORA_LENGTH = ORA_NCLOB.getMethod("getLength", new Class[0]);
                ORA_GET_CHARS = ORA_NCLOB.getMethod("getChars", Long.TYPE, Integer.TYPE, char[].class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Could not initialize the oracle NCLOB converter", e);
            }
        }
    }

    static class OracleNClobConverter
    implements Converter {
        OracleNClobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)ORA_LENGTH.invoke(source, new Object[0])).intValue();
            char[] buffer = new char[length];
            ORA_GET_CHARS.invoke(source, 1L, length, buffer);
            return target.cast(new String(buffer));
        }
    }
}

