/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle.sdo;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import org.geotools.data.oracle.sdo.AttributeList;
import org.geotools.data.oracle.sdo.CoordinateAccess;
import org.geotools.data.oracle.sdo.CoordinateAccessFactory;
import org.geotools.data.oracle.sdo.OrdinateList;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.PrecisionModel;

public class Coordinates {
    private Coordinates() {
    }

    public static CoordinateSequence subList(CoordinateSequenceFactory factory, CoordinateSequence sequence, int fromIndex, int toIndex) {
        List sublist;
        if (fromIndex == 0 && toIndex == sequence.size()) {
            return sequence;
        }
        if (sequence instanceof List && (sublist = ((List)sequence).subList(fromIndex, toIndex)) instanceof CoordinateSequence) {
            return (CoordinateSequence)sublist;
        }
        if (sequence instanceof CoordinateAccess) {
            int i;
            CoordinateAccess access = (CoordinateAccess)sequence;
            double[][] coordArray = access.toOrdinateArrays();
            Object[] attributeArray = access.toAttributeArrays();
            double[][] subCoordArray = new double[access.getDimension()][];
            Object[][] subAttributeArray = new Object[access.getNumAttributes()][];
            for (i = 0; i < access.getDimension(); ++i) {
                subCoordArray[i] = new OrdinateList(coordArray[i], 0, 1, fromIndex, toIndex).toDoubleArray();
            }
            for (i = 0; i < access.getNumAttributes(); ++i) {
                subAttributeArray[i] = new AttributeList(attributeArray[i], 0, 1, fromIndex, toIndex).toObjectArray();
            }
            CoordinateAccess c = ((CoordinateAccessFactory)factory).create(subCoordArray, (Object[])subAttributeArray);
            return c;
        }
        int size = toIndex - fromIndex;
        CoordinateSequence newSeq = JTS.createCS((CoordinateSequenceFactory)factory, (int)size, (int)sequence.getDimension());
        CoordinateSequences.copy((CoordinateSequence)sequence, (int)fromIndex, (CoordinateSequence)newSeq, (int)0, (int)size);
        return newSeq;
    }

    public static CoordinateSequence reverse(CoordinateSequenceFactory factory, CoordinateSequence sequence) {
        if (sequence instanceof CoordinateAccess) {
            int i;
            CoordinateAccess access = (CoordinateAccess)sequence;
            double[][] coordArray = access.toOrdinateArrays();
            Object[] attributeArray = access.toAttributeArrays();
            double[][] subCoordArray = new double[access.getDimension()][];
            Object[][] subAttributeArray = new Object[access.getNumAttributes()][];
            for (i = 0; i < access.getDimension(); ++i) {
                subCoordArray[i] = new OrdinateList(coordArray[i], 0, 1, access.size() - 1, -1).toDoubleArray();
            }
            for (i = 0; i < access.getNumAttributes(); ++i) {
                subAttributeArray[i] = new AttributeList(attributeArray[i], 0, 1, access.size() - 1, -1).toObjectArray();
            }
            CoordinateAccess c = ((CoordinateAccessFactory)factory).create(subCoordArray, (Object[])subAttributeArray);
            return c;
        }
        CoordinateSequence revSeq = factory.create(sequence);
        CoordinateSequences.reverse((CoordinateSequence)revSeq);
        return revSeq;
    }

    public static String toString(CoordinateSequence cs, int coordinate, NumberFormat nf) {
        StringBuffer buf = new StringBuffer();
        Coordinates.append(buf, cs, coordinate, nf);
        return buf.toString();
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, int coordinate, NumberFormat nf) {
        if (cs instanceof CoordinateAccess) {
            CoordinateAccess ca = (CoordinateAccess)cs;
            Coordinates.append(buf, ca, coordinate, Coordinates.LEN(ca), nf);
        } else {
            Coordinates.append(buf, cs, coordinate, Coordinates.LEN(cs), nf);
        }
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, int coordinate, int LEN, NumberFormat nf) {
        Coordinate c = cs.getCoordinate(coordinate);
        buf.append(nf.format(c.x));
        buf.append(" ");
        buf.append(nf.format(c.y));
        if (LEN == 3) {
            buf.append(" ");
            buf.append(nf.format(c.getZ()));
        }
    }

    public static void append(StringBuffer buf, CoordinateAccess ca, int coordinate, int LEN, NumberFormat nf) {
        buf.append(nf.format(ca.getOrdinate(coordinate, 0)));
        for (int i = 1; i < LEN; ++i) {
            buf.append(" ");
            buf.append(nf.format(ca.getOrdinate(coordinate, i)));
        }
    }

    public static int LEN(CoordinateSequence cs) {
        return Coordinates.D(cs) + Coordinates.L(cs);
    }

    public static int D(CoordinateSequence cs) {
        if (cs instanceof CoordinateAccess) {
            return cs.getDimension();
        }
        if (cs.size() > 0) {
            return Double.isNaN(cs.getCoordinate(0).getZ()) ? 2 : 3;
        }
        return 3;
    }

    public static int L(CoordinateSequence cs) {
        if (cs instanceof CoordinateAccess) {
            return ((CoordinateAccess)cs).getNumAttributes();
        }
        return 0;
    }

    public static NumberFormat format(PrecisionModel pm) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setNaN("NaN");
        DecimalFormat f = new DecimalFormat();
        f.setDecimalFormatSymbols(symbols);
        if (pm == null) {
            f.setMaximumFractionDigits(0);
            return f;
        }
        f.setMinimumFractionDigits(0);
        f.setMaximumFractionDigits(pm.getMaximumSignificantDigits());
        return f;
    }

    public static String toString(CoordinateSequence cs, PrecisionModel pm) {
        StringBuffer buf = new StringBuffer();
        Coordinates.append(buf, cs, Coordinates.format(pm));
        return buf.toString();
    }

    public static void append(StringBuffer buf, CoordinateSequence cs, NumberFormat nf) {
        if (cs instanceof CoordinateAccess) {
            Coordinates.append(buf, (CoordinateAccess)cs, nf);
        } else {
            int LEN = Coordinates.LEN(cs);
            if (cs.size() == 0) {
                return;
            }
            Coordinates.append(buf, cs, 0, LEN, nf);
            if (cs.size() == 1) {
                return;
            }
            for (int i = 1; i < cs.size(); ++i) {
                buf.append(", ");
                Coordinates.append(buf, cs, i, LEN, nf);
            }
        }
    }

    public static void append(StringBuffer buf, CoordinateAccess ca, NumberFormat nf) {
        int LEN = Coordinates.LEN(ca);
        if (ca.size() == 0) {
            return;
        }
        Coordinates.append(buf, ca, 0, LEN, nf);
        if (ca.size() == 1) {
            return;
        }
        for (int i = 1; i < ca.size(); ++i) {
            buf.append(", ");
            Coordinates.append(buf, ca, i, LEN, nf);
        }
    }
}

