/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.lang.reflect.Method;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class OracleBlobConverterFactory
implements ConverterFactory {
    OracleDateConverter converter = new OracleDateConverter();
    static final Class<?> ORA_BLOB;
    static final Method ORA_GET_BYTES;
    static final Method ORA_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ORA_BLOB == null) {
            return null;
        }
        if (!byte[].class.equals(target)) {
            return null;
        }
        if (!ORA_BLOB.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> oracleBlobClass = null;
        try {
            oracleBlobClass = Class.forName("oracle.sql.BLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (oracleBlobClass == null) {
            ORA_BLOB = null;
            ORA_GET_BYTES = null;
            ORA_LENGTH = null;
        } else {
            try {
                ORA_BLOB = oracleBlobClass;
                ORA_LENGTH = ORA_BLOB.getMethod("length", new Class[0]);
                ORA_GET_BYTES = ORA_BLOB.getMethod("getBytes", Long.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the oracle blob converter", e);
            }
        }
    }

    class OracleDateConverter
    implements Converter {
        OracleDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)ORA_LENGTH.invoke(source, new Object[0])).intValue();
            return target.cast(ORA_GET_BYTES.invoke(source, 1L, length));
        }
    }
}

