/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.mysql.MySQLDialect;
import org.geotools.data.mysql.MySQLFilterToSQL;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class MySQLDialectBasic
extends BasicSQLDialect {
    MySQLDialect delegate;

    public MySQLDialectBasic(JDBCDataStore dataStore) {
        this(dataStore, false);
    }

    public MySQLDialectBasic(JDBCDataStore dataStore, boolean usePreciseSpatialOps) {
        super(dataStore);
        this.delegate = new MySQLDialect(dataStore);
        this.delegate.setUsePreciseSpatialOps(usePreciseSpatialOps);
    }

    public void setStorageEngine(String storageEngine) {
        this.delegate.setStorageEngine(storageEngine);
    }

    public void setUsePreciseSpatialOps(boolean usePreciseSpatialOps) {
        this.delegate.setUsePreciseSpatialOps(usePreciseSpatialOps);
    }

    public boolean getUsePreciseSpatialOps() {
        return this.delegate.getUsePreciseSpatialOps();
    }

    public boolean isMySqlVersion80OrAbove() {
        return this.delegate.isMySqlVersion80OrAbove;
    }

    public void setMySqlVersion80OrAbove(boolean mySqlVersion80OrAbove) {
        this.delegate.isMySqlVersion80OrAbove = mySqlVersion80OrAbove;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return this.delegate.includeTable(schemaName, tableName, cx);
    }

    public String getNameEscape() {
        return this.delegate.getNameEscape();
    }

    public String getGeometryTypeName(Integer type) {
        return this.delegate.getGeometryTypeName(type);
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getGeometrySRID(schemaName, tableName, columnName, cx);
    }

    public void encodeColumnName(String prefix, String raw, StringBuffer sql) {
        this.delegate.encodeColumnName(prefix, raw, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql) {
        this.delegate.encodeColumnName(prefix, gatt.getLocalName(), sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.delegate.encodeGeometryColumn(gatt, prefix, srid, hints, sql);
    }

    public void encodeColumnType(String sqlTypeName, StringBuffer sql) {
        this.delegate.encodeColumnType(sqlTypeName, sql);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        this.delegate.registerClassToSqlMappings(mappings);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        this.delegate.registerSqlTypeToClassMappings(mappings);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        this.delegate.registerSqlTypeNameToClassMappings(mappings);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        this.delegate.registerSqlTypeToSqlTypeNameOverrides(overrides);
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
        this.delegate.encodePostCreateTable(tableName, sql);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        this.delegate.encodePostColumnCreateTable(att, sql);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        this.delegate.postCreateTable(schemaName, featureType, cx);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.delegate.encodePrimaryKey(column, sql);
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return this.delegate.lookupGeneratedValuesPostInsert();
    }

    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getNextAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        return this.delegate.getLastAutoGeneratedValue(schemaName, tableName, columnName, cx);
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value != null) {
            if (this.delegate.usePreciseSpatialOps) {
                sql.append("ST_GeomFromText('");
                if (srid < 0) {
                    srid = 0;
                }
            } else {
                sql.append("GeomFromText('");
            }
            sql.append(new WKTWriter().write(value));
            sql.append("', ").append(srid).append(")");
        } else {
            sql.append("NULL");
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        this.delegate.encodeGeometryEnvelope(tableName, geometryColumn, sql);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        return this.delegate.decodeGeometryEnvelope(rs, column, cx);
    }

    public boolean isLimitOffsetSupported() {
        return this.delegate.isLimitOffsetSupported();
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        this.delegate.applyLimitOffset(sql, limit, offset);
    }

    public FilterToSQL createFilterToSQL() {
        return new MySQLFilterToSQL(this.delegate.getUsePreciseSpatialOps());
    }

    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        this.delegate.dropIndex(cx, schema, databaseSchema, indexName);
    }
}

