/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.geometry.jts.Geometries;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MySQLDialect
extends SQLDialect {
    protected Integer POINT = 2001;
    protected Integer LINESTRING = 2002;
    protected Integer POLYGON = 2003;
    protected Integer MULTIPOINT = 2004;
    protected Integer MULTILINESTRING = 2005;
    protected Integer MULTIPOLYGON = 2006;
    protected Integer GEOMETRY = 2007;
    protected String storageEngine;
    protected boolean usePreciseSpatialOps;
    protected boolean isMySqlVersion80OrAbove;

    public MySQLDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void setStorageEngine(String storageEngine) {
        this.storageEngine = storageEngine;
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setUsePreciseSpatialOps(boolean usePreciseSpatialOps) {
        this.usePreciseSpatialOps = usePreciseSpatialOps;
    }

    public boolean getUsePreciseSpatialOps() {
        return this.usePreciseSpatialOps;
    }

    public boolean isMySqlVersion80OrAbove() {
        return this.isMySqlVersion80OrAbove;
    }

    public void setMySqlVersion80OrAbove(boolean mySqlVersion80OrAbove) {
        this.isMySqlVersion80OrAbove = mySqlVersion80OrAbove;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if ("geometry_columns".equalsIgnoreCase(tableName)) {
            return false;
        }
        return super.includeTable(schemaName, tableName, cx);
    }

    public String getNameEscape() {
        return this.usePreciseSpatialOps ? "`" : "";
    }

    public String getGeometryTypeName(Integer type) {
        if (this.POINT.equals(type)) {
            return "POINT";
        }
        if (this.MULTIPOINT.equals(type)) {
            return "MULTIPOINT";
        }
        if (this.LINESTRING.equals(type)) {
            return "LINESTRING";
        }
        if (this.MULTILINESTRING.equals(type)) {
            return "MULTILINESTRING";
        }
        if (this.POLYGON.equals(type)) {
            return "POLYGON";
        }
        if (this.MULTIPOLYGON.equals(type)) {
            return "MULTIPOLYGON";
        }
        if (this.GEOMETRY.equals(type)) {
            return "GEOMETRY";
        }
        return super.getGeometryTypeName(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet rs2;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.encodeColumnName(null, "srid", sql);
        sql.append(" FROM ");
        this.encodeTableName("geometry_columns", sql);
        sql.append(" WHERE ");
        this.encodeColumnName(null, "f_table_schema", sql);
        if (schemaName != null) {
            sql.append(" = '").append(schemaName).append("'");
        } else {
            sql.append(" IS NULL");
        }
        sql.append(" AND ");
        this.encodeColumnName(null, "f_table_name", sql);
        sql.append(" = '").append(tableName).append("' AND ");
        this.encodeColumnName(null, "f_geometry_column", sql);
        sql.append(" = '").append(columnName).append("'");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            rs2 = st.executeQuery(sql.toString());
            try {
                if (rs2.next()) {
                    Integer n = rs2.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs2);
            }
        }
        catch (SQLException rs2) {
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        sql = new StringBuffer();
        if (this.usePreciseSpatialOps) {
            sql.append("SELECT ST_SRID(");
        } else {
            sql.append("SELECT srid(");
        }
        this.encodeColumnName(null, columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        st = cx.createStatement();
        try {
            block24: {
                Integer n;
                rs2 = st.executeQuery(sql.toString());
                try {
                    if (!rs2.next()) break block24;
                    n = rs2.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs2);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs2);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs2);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        if (this.usePreciseSpatialOps) {
            sql.append("ST_asWKB(");
        } else {
            sql.append("asWKB(");
        }
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        if (this.usePreciseSpatialOps) {
            if (this.isMySqlVersion80OrAbove) {
                sql.append("ST_asWKB(ST_SRID(ST_Envelope(ST_SRID(");
                this.encodeColumnName(null, geometryColumn, sql);
                sql.append(",0)),ST_SRID(");
                this.encodeColumnName(null, geometryColumn, sql);
                sql.append(")");
            } else {
                sql.append("ST_asWKB(ST_Envelope(");
                this.encodeColumnName(null, geometryColumn, sql);
            }
        } else {
            sql.append("asWKB(");
            sql.append("envelope(");
            this.encodeColumnName(null, geometryColumn, sql);
        }
        sql.append("))");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        byte[] wkb = rs.getBytes(column);
        try {
            Geometry geom = new WKBReader().read(wkb);
            return geom.getEnvelopeInternal();
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb for envelope";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(name);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Point.class, this.POINT);
        mappings.put(LineString.class, this.LINESTRING);
        mappings.put(Polygon.class, this.POLYGON);
        mappings.put(MultiPoint.class, this.MULTIPOINT);
        mappings.put(MultiLineString.class, this.MULTILINESTRING);
        mappings.put(MultiPolygon.class, this.MULTIPOLYGON);
        mappings.put(Geometry.class, this.GEOMETRY);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(this.POINT, Point.class);
        mappings.put(this.LINESTRING, LineString.class);
        mappings.put(this.POLYGON, Polygon.class);
        mappings.put(this.MULTIPOINT, MultiPoint.class);
        mappings.put(this.MULTILINESTRING, MultiLineString.class);
        mappings.put(this.MULTIPOLYGON, MultiPolygon.class);
        mappings.put(this.GEOMETRY, Geometry.class);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("POINT", Point.class);
        mappings.put("LINESTRING", LineString.class);
        mappings.put("POLYGON", Polygon.class);
        mappings.put("MULTIPOINT", MultiPoint.class);
        mappings.put("MULTILINESTRING", MultiLineString.class);
        mappings.put("MULTIPOLYGON", MultiPolygon.class);
        mappings.put("GEOMETRY", Geometry.class);
        mappings.put("GEOMETRYCOLLECTION", GeometryCollection.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(16, "BOOL");
    }

    public void encodePostCreateTable(String tableName, StringBuffer sql) {
        sql.append("ENGINE=" + this.storageEngine);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        if (att instanceof GeometryDescriptor && !att.isNillable() && !sql.toString().trim().endsWith(" NOT NULL")) {
            sql.append(" NOT NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        block18: {
            DatabaseMetaData md = cx.getMetaData();
            ResultSet rs = md.getTables(null, this.dataStore.escapeNamePattern(md, schemaName), this.dataStore.escapeNamePattern(md, "geometry_columns"), new String[]{"TABLE"});
            try {
                if (rs.next()) break block18;
                Statement st = cx.createStatement();
                try {
                    StringBuffer sql = new StringBuffer("CREATE TABLE ");
                    this.encodeTableName("geometry_columns", sql);
                    sql.append("(");
                    this.encodeColumnName(null, "f_table_schema", sql);
                    sql.append(" varchar(255), ");
                    this.encodeColumnName(null, "f_table_name", sql);
                    sql.append(" varchar(255), ");
                    this.encodeColumnName(null, "f_geometry_column", sql);
                    sql.append(" varchar(255), ");
                    this.encodeColumnName(null, "coord_dimension", sql);
                    sql.append(" int, ");
                    this.encodeColumnName(null, "srid", sql);
                    sql.append(" int, ");
                    this.encodeColumnName(null, "type", sql);
                    sql.append(" varchar(32)");
                    sql.append(")");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(sql.toString());
                    }
                    st.execute(sql.toString());
                }
                finally {
                    this.dataStore.closeSafe(st);
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            if (!ad.isNillable()) {
                StringBuffer sql = new StringBuffer("ALTER TABLE ");
                this.encodeTableName(featureType.getTypeName(), sql);
                sql.append(" ADD SPATIAL INDEX (");
                this.encodeColumnName(null, gd.getLocalName(), sql);
                sql.append(")");
                LOGGER.fine(sql.toString());
                Statement st = cx.createStatement();
                try {
                    st.execute(sql.toString());
                }
                finally {
                    this.dataStore.closeSafe(st);
                }
            }
            CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
            int srid = 0;
            if (crs != null) {
                Integer i = null;
                try {
                    i = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINER, "Could not determine epsg code", e);
                }
                srid = i != null ? i : srid;
            }
            StringBuffer sql = new StringBuffer("INSERT INTO ");
            this.encodeTableName("geometry_columns", sql);
            sql.append(" (");
            this.encodeColumnName(null, "f_table_schema", sql);
            sql.append(", ");
            this.encodeColumnName(null, "f_table_name", sql);
            sql.append(", ");
            this.encodeColumnName(null, "f_geometry_column", sql);
            sql.append(", ");
            this.encodeColumnName(null, "coord_dimension", sql);
            sql.append(", ");
            this.encodeColumnName(null, "srid", sql);
            sql.append(", ");
            this.encodeColumnName(null, "type", sql);
            sql.append(") ");
            sql.append(" VALUES (");
            sql.append(schemaName != null ? "'" + schemaName + "'" : "NULL").append(", ");
            sql.append("'").append(featureType.getTypeName()).append("', ");
            sql.append("'").append(ad.getLocalName()).append("', ");
            sql.append("2, ");
            sql.append(srid).append(", ");
            Geometries g = Geometries.getForBinding((Class)gd.getType().getBinding());
            sql.append("'").append(g != null ? g.getName().toUpperCase() : "GEOMETRY").append("')");
            LOGGER.fine(sql.toString());
            Statement st = cx.createStatement();
            try {
                st.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" int AUTO_INCREMENT PRIMARY KEY");
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT last_insert_id()";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            if (offset > 0) {
                sql.append(" LIMIT " + offset + ", " + limit);
            } else {
                sql.append(" LIMIT " + limit);
            }
        } else if (offset > 0) {
            sql.append(" LIMIT " + offset + ", " + Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(Connection cx, SimpleFeatureType schema, String databaseSchema, String indexName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String escape = this.getNameEscape();
        sql.append("DROP INDEX ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        sql.append(escape).append(indexName).append(escape);
        sql.append(" on ");
        if (databaseSchema != null) {
            this.encodeSchemaName(databaseSchema, sql);
            sql.append(".");
        }
        this.encodeTableName(schema.getTypeName(), sql);
        Statement st = null;
        try {
            st = cx.createStatement();
            st.execute(sql.toString());
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(cx);
        }
    }
}

