/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class MySQLFilterToSQL
extends FilterToSQL {
    protected boolean usePreciseSpatialOps;

    public MySQLFilterToSQL() {
        this(false);
    }

    public MySQLFilterToSQL(boolean usePreciseSpatialOps) {
        this.usePreciseSpatialOps = usePreciseSpatialOps;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        if (this.usePreciseSpatialOps) {
            this.out.write("ST_GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
        } else {
            this.out.write("GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
        }
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        if (this.usePreciseSpatialOps) {
            return this.visitBinarySpatialOperatorEnhanced(filter, (Expression)property, (Expression)geometry, swapped, extraData);
        }
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        if (this.usePreciseSpatialOps) {
            return this.visitBinarySpatialOperatorEnhanced(filter, e1, e2, false, extraData);
        }
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            if (!(filter instanceof Disjoint)) {
                this.out.write("MbrIntersects(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (!(filter instanceof BBOX)) {
                    this.out.write(" AND ");
                }
            }
            if (filter instanceof BBOX) {
                return extraData;
            }
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("Distance(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (!(filter instanceof BBOX)) {
                if (filter instanceof Contains) {
                    this.out.write("Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + String.valueOf(filter));
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    protected Object visitBinarySpatialOperatorEnhanced(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("ST_Distance(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else if (filter instanceof BBOX) {
                this.out.write("MBRIntersects(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
            } else {
                if (filter instanceof Contains) {
                    this.out.write("ST_Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("ST_Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("ST_Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("ST_Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("ST_Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("ST_Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("ST_Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("ST_Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + String.valueOf(filter));
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }
}

