/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.mysql.MySQLDialectBasic;
import org.geotools.data.mysql.MySQLDialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class MySQLDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"mysql", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)3306);
    public static final DataAccessFactory.Param STORAGE_ENGINE = new DataAccessFactory.Param("storage engine", String.class, "Storage Engine", false, (Object)"MyISAM");
    public static final DataAccessFactory.Param ENHANCED_SPATIAL_SUPPORT = new DataAccessFactory.Param("enhancedSpatialSupport", Boolean.class, "Enhanced Spatial Support", false, (Object)false);
    protected boolean enhancedSpatialSupport;

    public MySQLDataStoreFactory() {
        this.enhancedSpatialSupport = (Boolean)MySQLDataStoreFactory.ENHANCED_SPATIAL_SUPPORT.sample;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new MySQLDialectBasic(dataStore, this.enhancedSpatialSupport);
    }

    public String getDisplayName() {
        return "MySQL";
    }

    protected String getDriverClassName() {
        return "com.mysql.cj.jdbc.Driver";
    }

    protected String getDatabaseID() {
        return (String)MySQLDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "MySQL Database";
    }

    protected String getValidationQuery() {
        return "select version()";
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.put(MySQLDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(MySQLDataStoreFactory.PORT.key, PORT);
        parameters.put(MySQLDataStoreFactory.STORAGE_ENGINE.key, STORAGE_ENGINE);
        parameters.remove(MySQLDataStoreFactory.SCHEMA.key);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        Boolean enhancedSpatialFlag;
        String storageEngine = (String)STORAGE_ENGINE.lookUp(params);
        if (storageEngine == null) {
            storageEngine = (String)MySQLDataStoreFactory.STORAGE_ENGINE.sample;
        }
        if ((enhancedSpatialFlag = (Boolean)ENHANCED_SPATIAL_SUPPORT.lookUp(params)) == null) {
            this.enhancedSpatialSupport = MySQLDataStoreFactory.isMySqlVersion56OrAbove(dataStore);
        } else if (enhancedSpatialFlag.booleanValue() && !MySQLDataStoreFactory.isMySqlVersion56OrAbove(dataStore)) {
            dataStore.getLogger().info("MySQL version does not support enhancedSpatialSupport. Disabling it");
            this.enhancedSpatialSupport = false;
        }
        SQLDialect dialect = dataStore.getSQLDialect();
        if (dialect instanceof MySQLDialectBasic) {
            ((MySQLDialectBasic)dialect).setStorageEngine(storageEngine);
            ((MySQLDialectBasic)dialect).setUsePreciseSpatialOps(this.enhancedSpatialSupport);
            ((MySQLDialectBasic)dialect).setMySqlVersion80OrAbove(MySQLDataStoreFactory.isMySqlVersion80OrAbove(dataStore));
        } else {
            ((MySQLDialectPrepared)dialect).setStorageEngine(storageEngine);
            ((MySQLDialectPrepared)dialect).setUsePreciseSpatialOps(this.enhancedSpatialSupport);
            ((MySQLDialectPrepared)dialect).setMySqlVersion80OrAbove(MySQLDataStoreFactory.isMySqlVersion80OrAbove(dataStore));
        }
        return dataStore;
    }

    protected static boolean isMySqlVersion56OrAbove(JDBCDataStore dataStore) {
        boolean isMySQLVersion56OrAbove = false;
        try (Connection con = dataStore.getDataSource().getConnection();){
            int major = con.getMetaData().getDatabaseMajorVersion();
            int minor = con.getMetaData().getDatabaseMinorVersion();
            isMySQLVersion56OrAbove = major > 5 || major == 5 && minor > 6;
        }
        catch (IllegalStateException | SQLException e) {
            dataStore.getLogger().warning("Unable to determine database version. Message: " + e.getLocalizedMessage());
        }
        return isMySQLVersion56OrAbove;
    }

    protected static boolean isMySqlVersion80OrAbove(JDBCDataStore dataStore) {
        boolean isMySQLVersion80OrAbove = false;
        try (Connection con = dataStore.getDataSource().getConnection();){
            int major = con.getMetaData().getDatabaseMajorVersion();
            isMySQLVersion80OrAbove = major >= 8;
        }
        catch (IllegalStateException | SQLException e) {
            dataStore.getLogger().warning("Unable to determine database version. Message: " + e.getLocalizedMessage());
        }
        return isMySQLVersion80OrAbove;
    }
}

