/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.informix;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.data.informix.InformixFilterToSQL;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;

public class InformixDialect
extends BasicSQLDialect {
    public InformixDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if ("geometry_columns".equalsIgnoreCase(tableName)) {
            return false;
        }
        return super.includeTable(schemaName, tableName, cx);
    }

    public String getNameEscape() {
        return "";
    }

    public String getGeometryTypeName(Integer type) {
        return "st_geometry";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ResultSet rs2;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        this.encodeColumnName(null, "srid", sql);
        sql.append(" FROM ");
        this.encodeTableName("geometry_columns", sql);
        sql.append(" WHERE ");
        this.encodeColumnName(null, "f_table_schema", sql);
        if (schemaName != null) {
            sql.append(" = '").append(schemaName).append("'");
        } else {
            sql.append(" IS NULL");
        }
        sql.append(" AND ");
        this.encodeColumnName(null, "f_table_name", sql);
        sql.append(" = '").append(tableName).append("' AND ");
        this.encodeColumnName(null, "f_geometry_column", sql);
        sql.append(" = '").append(columnName).append("'");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            rs2 = st.executeQuery(sql.toString());
            try {
                if (rs2.next()) {
                    Integer n = rs2.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs2);
            }
        }
        catch (SQLException rs2) {
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        sql = new StringBuffer();
        sql.append("SELECT st_srid(");
        this.encodeColumnName(null, columnName, sql);
        sql.append(") ");
        sql.append("FROM ");
        if (schemaName != null) {
            this.encodeTableName(schemaName, sql);
            sql.append(".");
        }
        this.encodeSchemaName(tableName, sql);
        sql.append(" WHERE ");
        this.encodeColumnName(null, columnName, sql);
        sql.append(" is not null LIMIT 1");
        this.dataStore.getLogger().fine(sql.toString());
        st = cx.createStatement();
        try {
            block22: {
                Integer n;
                rs2 = st.executeQuery(sql.toString());
                try {
                    if (!rs2.next()) break block22;
                    n = rs2.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs2);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs2);
                return n;
            }
            Integer n = null;
            this.dataStore.closeSafe(rs2);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        sql.append("st_asbinary(");
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_AsBinary(");
        sql.append("ST_Envelope(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) {
        if (value != null) {
            String fromText = this.fromTextFunctionName(value);
            sql.append(fromText + "('");
            sql.append(new WKTWriter().write(value));
            if (srid == -1) {
                LOGGER.warning("SRID -1 is not supported, using 0");
                srid = 0;
            }
            sql.append("', ").append(srid).append(")");
        } else {
            sql.append("NULL");
        }
    }

    private String fromTextFunctionName(Geometry value) {
        if (value instanceof Point) {
            return "ST_PointFromText";
        }
        if (value instanceof LineString) {
            return "ST_LineFromText";
        }
        if (value instanceof Polygon) {
            return "ST_PolyFromText";
        }
        if (value instanceof MultiPoint) {
            return "ST_MPointFromText";
        }
        if (value instanceof MultiLineString) {
            return "ST_MLineFromText";
        }
        if (value instanceof MultiPolygon) {
            return "ST_MPolyFromText";
        }
        return "ST_GeomFromText";
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        byte[] wkb = rs.getBytes(column);
        if (wkb == null) {
            return null;
        }
        try {
            Geometry geom = new WKBReader().read(wkb);
            return geom.getEnvelopeInternal();
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb for envelope";
            throw new IOException(msg, e);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
    }

    private int getGeometryTypeNumber(String className) {
        if (className.equals(Point.class.getSimpleName())) {
            return 1;
        }
        if (className.equals(LineString.class.getSimpleName())) {
            return 3;
        }
        if (className.equals(Polygon.class.getSimpleName())) {
            return 5;
        }
        if (className.equals(MultiPoint.class.getSimpleName())) {
            return 7;
        }
        if (className.equals(MultiLineString.class.getSimpleName())) {
            return 9;
        }
        if (className.equals(MultiPolygon.class.getSimpleName())) {
            return 11;
        }
        if (className.equals(GeometryCollection.class.getSimpleName())) {
            return 6;
        }
        return 0;
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("st_point", Point.class);
        mappings.put("st_linestring", LineString.class);
        mappings.put("st_polygon", Polygon.class);
        mappings.put("st_multipoint", MultiPoint.class);
        mappings.put("st_multilinestring", MultiLineString.class);
        mappings.put("st_multipolygon", MultiPolygon.class);
        mappings.put("st_geometry", Geometry.class);
        mappings.put("st_geometrycollection", GeometryCollection.class);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        if (att instanceof GeometryDescriptor && !att.isNillable() && !sql.toString().trim().endsWith(" NOT NULL")) {
            sql.append(" NOT NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gd = (GeometryDescriptor)ad;
            if (!ad.isNillable()) {
                StringBuffer sql = new StringBuffer("ALTER TABLE ");
                this.encodeTableName(featureType.getTypeName(), sql);
                sql.append(" ADD SPATIAL INDEX (");
                this.encodeColumnName(null, gd.getLocalName(), sql);
                sql.append(")");
                LOGGER.fine(sql.toString());
                Statement st = cx.createStatement();
                try {
                    st.execute(sql.toString());
                }
                finally {
                    this.dataStore.closeSafe(st);
                }
            }
            CoordinateReferenceSystem crs = gd.getCoordinateReferenceSystem();
            int srid = -1;
            if (crs != null) {
                Integer i = null;
                try {
                    i = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
                }
                catch (FactoryException e) {
                    LOGGER.log(Level.FINER, "Could not determine epsg code", e);
                }
                srid = i != null ? i : srid;
            }
            StringBuffer sql = new StringBuffer("INSERT INTO geometry_columns ");
            sql.append("(f_table_catalog, f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, geometry_type)");
            sql.append(" VALUES (");
            sql.append("DBINFO('dbname'), ");
            sql.append("'" + cx.getMetaData().getUserName() + "'").append(", ");
            sql.append("'").append(featureType.getTypeName()).append("', ");
            sql.append("'").append(ad.getLocalName()).append("', ");
            sql.append("2, ");
            sql.append(srid).append(", ");
            String typeName = ad.getType().getBinding().getSimpleName();
            int typeNumber = this.getGeometryTypeNumber(typeName);
            sql.append(typeNumber);
            sql.append(")");
            LOGGER.fine(sql.toString());
            Statement st = cx.createStatement();
            try {
                st.execute(sql.toString());
            }
            finally {
                this.dataStore.closeSafe(st);
            }
        }
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" SERIAL PRIMARY KEY");
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT DBINFO( 'sqlca.sqlerrd1' ) FROM systables LIMIT 1";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        int selectIndex = sql.indexOf("SELECT");
        if (selectIndex < 0) {
            throw new IllegalArgumentException("Cannot apply limit to a query that does not include SELECT");
        }
        String limitSql = null;
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            limitSql = offset > 0 ? " SKIP " + offset + " FIRST " + limit : " FIRST " + limit;
        } else if (offset > 0) {
            limitSql = " SKIP " + offset;
        }
        sql.insert(selectIndex + "SELECT".length(), limitSql);
    }

    public FilterToSQL createFilterToSQL() {
        return new InformixFilterToSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws IOException {
        String tableName = featureType.getTypeName();
        Statement st = null;
        ResultSet rs = null;
        ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                Envelope env;
                if (!(att instanceof GeometryDescriptor)) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("select ST_AsBinary(SE_BoundingBox('");
                sql.append(tableName);
                sql.append("', '");
                sql.append(att.getName().getLocalPart());
                sql.append("')) from systables where tabid = 1");
                rs = st.executeQuery(sql.toString());
                if (rs.next() && !(env = this.decodeGeometryEnvelope(rs, 1, cx)).isNull()) {
                    SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
                    result.add(new ReferencedEnvelope(env, (CoordinateReferenceSystem)flatCRS));
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to use SE_BoundingBox, falling back on envelope aggregation", e);
            List<ReferencedEnvelope> list = null;
            return list;
        }
        finally {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
        }
        return result;
    }
}

