/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.informix;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.informix.InformixDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class InformixDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"informix-sqli", Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", true, (Object)9088);
    public static final DataAccessFactory.Param JDBC_URL = new DataAccessFactory.Param("jdbcUrl", String.class, "The JDBC url (check the JDBC driver docs to find out its format)", true);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new InformixDialect(dataStore);
    }

    public String getDisplayName() {
        return "Informix";
    }

    protected String getDriverClassName() {
        return "com.informix.jdbc.IfxDriver";
    }

    protected String getDatabaseID() {
        return (String)InformixDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "Informix Database";
    }

    protected String getValidationQuery() {
        return "SELECT DBINFO('version','full') FROM systables WHERE tabid = 1";
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.put(InformixDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.remove(InformixDataStoreFactory.HOST.key);
        parameters.remove(InformixDataStoreFactory.PORT.key);
        parameters.remove(InformixDataStoreFactory.DATABASE.key);
        parameters.remove(InformixDataStoreFactory.SCHEMA.key);
        parameters.put(InformixDataStoreFactory.JDBC_URL.key, JDBC_URL);
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        if (params.containsKey("url")) {
            return (String)params.get("url");
        }
        return (String)JDBC_URL.lookUp(params);
    }
}

