/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.metadata;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.hana.metadata.CommandLineArguments;
import org.geotools.data.hana.metadata.MetadataDdl;
import org.geotools.data.hana.metadata.Srs;
import org.geotools.data.hana.metadata.SrsReader;
import org.geotools.data.hana.metadata.Uom;
import org.geotools.data.hana.metadata.UomReader;

public final class MetadataImport {
    public static void main(String[] args) {
        try {
            System.exit(MetadataImport.execute(args, new ConsolePasswordReader(System.console())));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static int execute(String[] args, IPasswordReader passwordReader) throws Exception {
        MetadataImport instance = new MetadataImport();
        return instance.run(args, passwordReader);
    }

    private MetadataImport() {
    }

    private int run(String[] args, IPasswordReader passwordReader) throws Exception {
        CommandLineArguments cla = CommandLineArguments.parse(args);
        if (cla == null) {
            return -1;
        }
        String password = new String(passwordReader.readPassword());
        try (Connection conn = DriverManager.getConnection(cla.getConnectionParameters().buildUrl(), cla.getUser(), password);){
            this.importUom(conn);
            this.importSrs(conn);
        }
        return 0;
    }

    private void importUom(Connection conn) throws SQLException, IOException {
        try (PreparedStatement psUomExists = conn.prepareStatement("SELECT COUNT(*) FROM PUBLIC.ST_UNITS_OF_MEASURE WHERE UNIT_NAME = ?");
             Statement createUom = conn.createStatement();
             InputStream is = MetadataImport.class.getResourceAsStream("uom.csv");){
            Uom uom;
            UomReader reader = new UomReader(is);
            while ((uom = reader.readNextUom()) != null) {
                if (this.doesUomExist(psUomExists, uom.getName())) {
                    System.out.println("Skipping UOM \"" + uom.getName() + "\" as it already exists");
                    continue;
                }
                System.out.println("Creating UOM \"" + uom.getName() + "\"");
                createUom.execute(MetadataDdl.getUomDdl(uom));
            }
        }
    }

    private boolean doesUomExist(PreparedStatement psUomExists, String name) throws SQLException {
        psUomExists.setString(1, name);
        try (ResultSet rs = psUomExists.executeQuery();){
            if (!rs.next()) {
                throw new AssertionError();
            }
            int count = rs.getInt(1);
            boolean bl = count > 0;
            return bl;
        }
    }

    private void importSrs(Connection conn) throws SQLException, IOException {
        try (PreparedStatement psSrsExists = conn.prepareStatement("SELECT COUNT(*) FROM PUBLIC.ST_SPATIAL_REFERENCE_SYSTEMS WHERE SRS_NAME = ? OR SRS_ID = ?");
             Statement createSrs = conn.createStatement();
             InputStream is = MetadataImport.class.getResourceAsStream("srs.csv");){
            Srs srs;
            SrsReader reader = new SrsReader(is);
            while ((srs = reader.readNextSrs()) != null) {
                if (this.doesSrsExist(psSrsExists, srs.getName(), srs.getSrid())) {
                    System.out.println("Skipping SRS \"" + srs.getName() + "\" as it already exists");
                    continue;
                }
                System.out.println("Creating SRS \"" + srs.getName() + "\"");
                createSrs.execute(MetadataDdl.getSrsDdl(srs));
            }
        }
    }

    private boolean doesSrsExist(PreparedStatement psSrsExists, String name, int srid) throws SQLException {
        psSrsExists.setString(1, name);
        psSrsExists.setInt(2, srid);
        try (ResultSet rs = psSrsExists.executeQuery();){
            if (!rs.next()) {
                throw new AssertionError();
            }
            int count = rs.getInt(1);
            boolean bl = count > 0;
            return bl;
        }
    }

    private static class ConsolePasswordReader
    implements IPasswordReader {
        private Console console;

        public ConsolePasswordReader(Console console) {
            if (console == null) {
                throw new NullPointerException("console must not be null");
            }
            this.console = console;
        }

        @Override
        public char[] readPassword() {
            return this.console.readPassword("Password: ", new Object[0]);
        }
    }

    public static interface IPasswordReader {
        public char[] readPassword();
    }
}

