/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.util.Objects;

class HanaVersion
implements Comparable<HanaVersion> {
    private int version;
    private int revision;
    private int patchLevel;
    private long buildId;

    public HanaVersion(String versionString) {
        String[] components = versionString.split("\\.");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid HANA version string " + versionString);
        }
        try {
            this.version = Integer.parseInt(components[0]);
            this.revision = Integer.parseInt(components[2]);
            this.patchLevel = Integer.parseInt(components[3]);
            this.buildId = Long.parseLong(components[4]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid HANA version string " + versionString);
        }
    }

    public HanaVersion(int version, int revision, int patchLevel, long buildId) {
        this.version = version;
        this.revision = revision;
        this.patchLevel = patchLevel;
        this.buildId = buildId;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public long getBuildId() {
        return this.buildId;
    }

    @Override
    public int compareTo(HanaVersion that) {
        if (that == null) {
            throw new NullPointerException();
        }
        if (this.version != that.version) {
            return Integer.compare(this.version, that.version);
        }
        if (this.revision != that.revision) {
            return Integer.compare(this.revision, that.revision);
        }
        if (this.patchLevel != that.patchLevel) {
            return Integer.compare(this.patchLevel, that.patchLevel);
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HanaVersion that = (HanaVersion)o;
        return this.version == that.version && this.revision == that.revision && this.patchLevel == that.patchLevel && this.buildId == that.buildId;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.revision, this.patchLevel, this.buildId);
    }
}

