/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

class CsvReader {
    private BufferedReader reader;

    public CsvReader(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public List<String> readNextRow() throws IOException {
        String entry;
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        Scanner scanner = new Scanner(line);
        ArrayList<String> ret = new ArrayList<String>();
        while ((entry = scanner.getNextEntry()) != null) {
            ret.add(entry);
        }
        return ret;
    }

    private static class Scanner {
        private String line;
        private int position;

        public Scanner(String line) {
            this.line = line;
            this.position = 0;
        }

        public String getNextEntry() {
            if (this.position == this.line.length()) {
                return null;
            }
            if (this.position > 0) {
                if (this.line.charAt(this.position) != ',') {
                    throw new AssertionError();
                }
                ++this.position;
            }
            if (this.position == this.line.length()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            boolean inQuotes = false;
            if (this.line.charAt(this.position) == '\"') {
                inQuotes = true;
                ++this.position;
            }
            while (this.position < this.line.length()) {
                char c = this.line.charAt(this.position);
                if (!inQuotes && c == ',') break;
                if (inQuotes && c == '\"') {
                    ++this.position;
                    if (this.position == this.line.length()) {
                        inQuotes = false;
                        break;
                    }
                    if (this.line.charAt(this.position) != '\"') {
                        inQuotes = false;
                        break;
                    }
                    sb.append('\"');
                    ++this.position;
                    continue;
                }
                sb.append(c);
                ++this.position;
            }
            if (inQuotes) {
                throw new RuntimeException("CSV-file is malformed");
            }
            if (this.position < this.line.length() && this.line.charAt(this.position) != ',') {
                throw new RuntimeException("CSV-file is malformed");
            }
            return sb.toString();
        }
    }
}

