/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

class HanaVersion {
    private int version;
    private int revision;
    private int patchLevel;
    private long buildId;

    public HanaVersion(String versionString) {
        String[] components = versionString.split("\\.");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid HANA version string " + versionString);
        }
        try {
            this.version = Integer.parseInt(components[0]);
            this.revision = Integer.parseInt(components[2]);
            this.patchLevel = Integer.parseInt(components[3]);
            this.buildId = Long.parseLong(components[4]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid HANA version string " + versionString);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public long getBuildId() {
        return this.buildId;
    }
}

