/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana.converter;

import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class BooleanConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Short.class.equals(source) && Boolean.class.equals(target)) {
            return new Converter(){

                public <T> T convert(Object source, Class<T> target) throws Exception {
                    if (source == null) {
                        throw new IllegalArgumentException("source must not be null");
                    }
                    Short s = (Short)source;
                    if (s == 0) {
                        return target.cast(Boolean.FALSE);
                    }
                    if (s == 1) {
                        return target.cast(Boolean.TRUE);
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

