/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HanaDimensionFinder {
    private HanaDimensionFinder() {
    }

    public static int findDimension(Geometry g) {
        return HanaDimensionFinder.allPointsHave3Coordinates(g) ? 3 : 2;
    }

    private static boolean allPointsHave3Coordinates(Geometry g) {
        if (g.isEmpty()) {
            return true;
        }
        if (g instanceof Point) {
            return HanaDimensionFinder.allPointsHave3Coordinates((Point)g);
        }
        if (g instanceof LineString) {
            return HanaDimensionFinder.allPointsHave3Coordinates((LineString)g);
        }
        if (g instanceof Polygon) {
            return HanaDimensionFinder.allPointsHave3Coordinates((Polygon)g);
        }
        if (g instanceof GeometryCollection) {
            return HanaDimensionFinder.allPointsHave3Coordinates((GeometryCollection)g);
        }
        throw new AssertionError();
    }

    private static boolean allPointsHave3Coordinates(Point p) {
        Coordinate c = p.getCoordinate();
        return !Double.isNaN(c.getZ());
    }

    private static boolean allPointsHave3Coordinates(LineString ls) {
        return HanaDimensionFinder.allPointsHave3Coordinates(ls.getCoordinateSequence());
    }

    private static boolean allPointsHave3Coordinates(Polygon pg) {
        if (!HanaDimensionFinder.allPointsHave3Coordinates((LineString)pg.getExteriorRing())) {
            return false;
        }
        int numHoles = pg.getNumInteriorRing();
        for (int i = 0; i < numHoles; ++i) {
            if (HanaDimensionFinder.allPointsHave3Coordinates((LineString)pg.getInteriorRingN(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean allPointsHave3Coordinates(GeometryCollection gc) {
        int numGeometries = gc.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            if (HanaDimensionFinder.allPointsHave3Coordinates(gc.getGeometryN(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean allPointsHave3Coordinates(CoordinateSequence cs) {
        if (cs.getDimension() < 3) {
            return false;
        }
        int size = cs.size();
        for (int i = 0; i < size; ++i) {
            if (!Double.isNaN(cs.getOrdinate(i, 2))) continue;
            return false;
        }
        return true;
    }
}

