/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.hana;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HanaConnectionParameters {
    private String host;
    private Integer port;
    private Map<String, String> additionalOptions;

    public static HanaConnectionParameters forPort(String host, int port) {
        return HanaConnectionParameters.forPort(host, port, null);
    }

    public static HanaConnectionParameters forPort(String host, int port, Map<String, String> additionalOptions) {
        return new HanaConnectionParameters(host, port, additionalOptions);
    }

    public static HanaConnectionParameters forSingleContainer(String host, int instance) {
        return HanaConnectionParameters.forSingleContainer(host, instance, null);
    }

    public static HanaConnectionParameters forSingleContainer(String host, int instance, Map<String, String> additionalOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (additionalOptions != null) {
            options.putAll(additionalOptions);
        }
        options.put("instanceNumber", Integer.toString(instance));
        return new HanaConnectionParameters(host, null, options);
    }

    public static HanaConnectionParameters forMultiContainerSystemDatabase(String host, int instance) {
        return HanaConnectionParameters.forMultiContainer(host, instance, "SYSTEMDB");
    }

    public static HanaConnectionParameters forMultiContainerSystemDatabase(String host, int instance, Map<String, String> additionalOptions) {
        return HanaConnectionParameters.forMultiContainer(host, instance, "SYSTEMDB", additionalOptions);
    }

    public static HanaConnectionParameters forMultiContainer(String host, int instance, String database) {
        return HanaConnectionParameters.forMultiContainer(host, instance, database, null);
    }

    public static HanaConnectionParameters forMultiContainer(String host, int instance, String database, Map<String, String> additionalOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (additionalOptions != null) {
            options.putAll(additionalOptions);
        }
        options.put("instanceNumber", Integer.toString(instance));
        options.put("databaseName", database);
        return new HanaConnectionParameters(host, null, options);
    }

    private HanaConnectionParameters(String host, Integer port, Map<String, String> additionalOptions) {
        this.host = host;
        this.port = port;
        this.additionalOptions = additionalOptions;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions == null ? null : Collections.unmodifiableMap(this.additionalOptions);
    }

    public String buildUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:sap://");
        sb.append(this.host);
        if (this.port != null) {
            sb.append(":");
            sb.append(this.port.toString());
        }
        if (this.additionalOptions != null && !this.additionalOptions.isEmpty()) {
            sb.append("/?");
            boolean first = true;
            for (Map.Entry<String, String> option : this.additionalOptions.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                try {
                    sb.append(URLEncoder.encode(option.getKey(), "UTF-8"));
                    sb.append('=');
                    sb.append(URLEncoder.encode(option.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return sb.toString();
    }
}

