/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.geotools;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.FilterFunction_strEndsWith;
import org.geotools.filter.function.FilterFunction_strEqualsIgnoreCase;
import org.geotools.filter.function.FilterFunction_strIndexOf;
import org.geotools.filter.function.FilterFunction_strLength;
import org.geotools.filter.function.FilterFunction_strReplace;
import org.geotools.filter.function.FilterFunction_strStartsWith;
import org.geotools.filter.function.FilterFunction_strSubstring;
import org.geotools.filter.function.FilterFunction_strSubstringStart;
import org.geotools.filter.function.FilterFunction_strToLowerCase;
import org.geotools.filter.function.FilterFunction_strToUpperCase;
import org.geotools.filter.function.FilterFunction_strTrim;
import org.geotools.filter.function.FilterFunction_strTrim2;
import org.geotools.filter.function.math.FilterFunction_abs;
import org.geotools.filter.function.math.FilterFunction_abs_2;
import org.geotools.filter.function.math.FilterFunction_abs_3;
import org.geotools.filter.function.math.FilterFunction_abs_4;
import org.geotools.filter.function.math.FilterFunction_ceil;
import org.geotools.filter.function.math.FilterFunction_exp;
import org.geotools.filter.function.math.FilterFunction_floor;
import org.geotools.jdbc.SQLDialect;

public class H2GISFilterToSQLHelper {
    FilterToSQL filterToSQL;
    Writer out;

    public H2GISFilterToSQLHelper(FilterToSQL filterToSQL) {
        this.filterToSQL = filterToSQL;
    }

    public static FilterCapabilities createFilterCapabilities(boolean encodeFunctions, FilterCapabilities superCaps) {
        FilterCapabilities caps = superCaps;
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        if (encodeFunctions) {
            caps.addType(FilterFunction_strConcat.class);
            caps.addType(FilterFunction_strEndsWith.class);
            caps.addType(FilterFunction_strStartsWith.class);
            caps.addType(FilterFunction_strEqualsIgnoreCase.class);
            caps.addType(FilterFunction_strIndexOf.class);
            caps.addType(FilterFunction_strLength.class);
            caps.addType(FilterFunction_strToLowerCase.class);
            caps.addType(FilterFunction_strToUpperCase.class);
            caps.addType(FilterFunction_strReplace.class);
            caps.addType(FilterFunction_strSubstring.class);
            caps.addType(FilterFunction_strSubstringStart.class);
            caps.addType(FilterFunction_strTrim.class);
            caps.addType(FilterFunction_strTrim2.class);
            caps.addType(FilterFunction_abs.class);
            caps.addType(FilterFunction_abs_2.class);
            caps.addType(FilterFunction_abs_3.class);
            caps.addType(FilterFunction_abs_4.class);
            caps.addType(FilterFunction_ceil.class);
            caps.addType(FilterFunction_floor.class);
            caps.addType(FilterFunction_exp.class);
        }
        return caps;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create this spatial filter", e);
        }
        return extraData;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        try {
            this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create this spatial filter", e);
        }
        return extraData;
    }

    private void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.out.write("ST_DWithin(");
            property.accept((ExpressionVisitor)this.filterToSQL, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.filterToSQL, extraData);
            this.out.write(",");
            this.out.write(String.valueOf(filter.getDistance()));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.out.write("ST_Distance(");
            property.accept((ExpressionVisitor)this.filterToSQL, extraData);
            this.out.write(",");
            geometry.accept((ExpressionVisitor)this.filterToSQL, extraData);
            this.out.write(") > ");
            this.out.write(Double.toString(filter.getDistance()));
        }
    }

    private void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (!(filter instanceof Disjoint)) {
            property.accept((ExpressionVisitor)this.filterToSQL, extraData);
            this.out.write(" && ");
            geometry.accept((ExpressionVisitor)this.filterToSQL, extraData);
            if (filter instanceof BBOX) {
                return;
            }
            this.out.write(" AND ");
        }
        this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    private void visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) throws IOException {
        Object closingParenthesis = ")";
        if (filter instanceof Equals) {
            this.out.write("ST_Equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("NOT (ST_Intersects");
            closingParenthesis = (String)closingParenthesis + ")";
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("ST_Intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("ST_Crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("ST_Contains");
            } else {
                this.out.write("ST_Within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("ST_Within");
            } else {
                this.out.write("ST_Contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("ST_Overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("ST_Touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        this.out.write("(");
        e1.accept((ExpressionVisitor)this.filterToSQL, extraData);
        this.out.write(", ");
        e2.accept((ExpressionVisitor)this.filterToSQL, extraData);
        this.out.write((String)closingParenthesis);
    }

    public static String getFunctionName(Function function) {
        if (function instanceof FilterFunction_strLength) {
            return "length";
        }
        if (function instanceof FilterFunction_strToLowerCase) {
            return "lower";
        }
        if (function instanceof FilterFunction_strToUpperCase) {
            return "upper";
        }
        if (function instanceof FilterFunction_abs || function instanceof FilterFunction_abs_2 || function instanceof FilterFunction_abs_3 || function instanceof FilterFunction_abs_4) {
            return "abs";
        }
        if (function instanceof FilterFunction_exp) {
            return "exp";
        }
        return function.getName();
    }

    public boolean visitFunction(Function function, Object extraData) throws IOException {
        if (function instanceof FilterFunction_strConcat) {
            Expression s1 = this.getParameter(function, 0, true);
            Expression s2 = this.getParameter(function, 1, true);
            this.out.write("(");
            s1.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(" || ");
            s2.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEndsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression end = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(" LIKE ");
            if (end instanceof Literal) {
                this.out.write("'%" + (String)end.evaluate(null, String.class) + "'");
            } else {
                this.out.write("('%' || ");
                end.accept((ExpressionVisitor)this.filterToSQL, String.class);
                this.out.write(")");
            }
            this.out.write(")");
        } else if (function instanceof FilterFunction_strStartsWith) {
            Expression str = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("(");
            str.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(" LIKE ");
            if (start instanceof Literal) {
                this.out.write("'" + (String)start.evaluate(null, String.class) + "%'");
            } else {
                this.out.write("(");
                start.accept((ExpressionVisitor)this.filterToSQL, String.class);
                this.out.write(" || '%')");
            }
            this.out.write(")");
        } else if (function instanceof FilterFunction_strEqualsIgnoreCase) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(lower(");
            first.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(") = lower(");
            second.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write("::text))");
        } else if (function instanceof FilterFunction_strIndexOf) {
            Expression first = this.getParameter(function, 0, true);
            Expression second = this.getParameter(function, 1, true);
            this.out.write("(POSITION(");
            first.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(", ");
            second.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strSubstring) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            Expression end = this.getParameter(function, 2, true);
            this.out.write("SUBSTRING(");
            string.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.filterToSQL, Integer.class);
            this.out.write(", ");
            end.accept((ExpressionVisitor)this.filterToSQL, Integer.class);
            this.out.write(")");
        } else if (function instanceof FilterFunction_strSubstringStart) {
            Expression string = this.getParameter(function, 0, true);
            Expression start = this.getParameter(function, 1, true);
            this.out.write("SUBSTRING(");
            string.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(", ");
            start.accept((ExpressionVisitor)this.filterToSQL, Integer.class);
            this.out.write(" + 1)");
        } else if (function instanceof FilterFunction_strTrim) {
            Expression string = this.getParameter(function, 0, true);
            this.out.write("trim(both ' ' from ");
            string.accept((ExpressionVisitor)this.filterToSQL, String.class);
            this.out.write(")");
        } else {
            return false;
        }
        return true;
    }

    private Expression getParameter(Function function, int idx, boolean mandatory) {
        List params = function.getParameters();
        if ((params == null || params.size() <= idx) && mandatory) {
            throw new IllegalArgumentException("Missing parameter number " + (idx + 1) + "for function " + function.getName() + ", cannot encode in SQL");
        }
        return (Expression)params.get(idx);
    }

    public String cast(String property, Class<?> target) {
        if (String.class.equals(target)) {
            return property + "::varchar";
        }
        if (Short.class.equals(target) || Byte.class.equals(target)) {
            return property + "::smallint";
        }
        if (Integer.class.equals(target)) {
            return property + "::integer";
        }
        if (Long.class.equals(target)) {
            return property + "::bigint";
        }
        if (Float.class.equals(target)) {
            return property + "::real";
        }
        if (Double.class.equals(target)) {
            return property + "::float8";
        }
        if (BigInteger.class.equals(target)) {
            return property + "::numeric";
        }
        if (BigDecimal.class.equals(target)) {
            return property + "::decimal";
        }
        if (Time.class.isAssignableFrom(target)) {
            return property + "::time";
        }
        if (Timestamp.class.isAssignableFrom(target)) {
            return property + "::timestamp";
        }
        if (Date.class.isAssignableFrom(target)) {
            return property + "::date";
        }
        if (java.util.Date.class.isAssignableFrom(target)) {
            return property + "::timesamp";
        }
        return property;
    }
}

