/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.geotools;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.h2.value.ValueGeometry;
import org.h2gis.functions.factory.H2GISFunctions;
import org.h2gis.geotools.H2GISFilterToSQL;
import org.h2gis.utilities.GeometryMetaData;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class H2GISDialect
extends BasicSQLDialect {
    private Version h2gisVersion;
    static final Version V_1_5_0 = new Version("1.5.0");
    static final Version V_2_0_0 = new Version("2.0.0");
    static Pattern GEOMETRY_TABLE_PATTERN = Pattern.compile("(?:(?:GEOMETRY\\s*\\(\\s*([a-zA-Z]+\\s*(?:[ZM]+)?)\\s*(?:,\\s*([\\d]+))?\\))|^\\s*([a-zA-Z]+\\s*(?:[ZM]+)?))", 2);
    static final Map<String, Class> TYPE_TO_CLASS_MAP = new HashMap<String, Class>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("POINTM", Point.class);
            this.put("POINTZ", Point.class);
            this.put("POINTZM", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("LINESTRINGM", LineString.class);
            this.put("LINESTRINGZ", LineString.class);
            this.put("LINESTRINGZM", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("POLYGONM", Polygon.class);
            this.put("POLYGONZ", Polygon.class);
            this.put("POLYGONZM", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTIPOINTM", MultiPoint.class);
            this.put("MULTIPOINTZ", MultiPoint.class);
            this.put("MULTIPOINTZM", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTILINESTRINGM", MultiLineString.class);
            this.put("MULTILINESTRINGZ", MultiLineString.class);
            this.put("MULTILINESTRINGZM", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("MULTIPOLYGONM", MultiPolygon.class);
            this.put("MULTIPOLYGONZ", MultiPolygon.class);
            this.put("MULTIPOLYGONZM", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("BYTEA", byte[].class);
        }
    };
    static final Map<Class<?>, String> CLASS_TO_TYPE_MAP = new HashMap<Class<?>, String>(){
        {
            this.put(Geometry.class, "GEOMETRY");
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINESTRING");
            this.put(Polygon.class, "POLYGON");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINESTRING");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
            this.put(GeometryCollection.class, "GEOMETRYCOLLECTION");
            this.put(LinearRing.class, "LINEARRING");
        }
    };
    boolean functionEncodingEnabled = true;
    boolean estimatedExtentsEnabled = false;

    public boolean isAggregatedSortSupported(String function) {
        return "distinct".equalsIgnoreCase(function);
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtentsEnabled) {
        this.estimatedExtentsEnabled = estimatedExtentsEnabled;
    }

    public H2GISDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isFunctionEncodingEnabled() {
        return this.functionEncodingEnabled;
    }

    public void initializeConnection(Connection cx) throws SQLException {
        super.initializeConnection(cx);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) {
        if (tableName.equalsIgnoreCase("geometry_columns")) {
            return false;
        }
        return !tableName.toLowerCase().startsWith("spatial_ref_sys");
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        boolean force2D;
        boolean bl = force2D = hints != null && hints.containsKey((Object)Hints.FEATURE_2D) && Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D));
        if (force2D) {
            sql.append("ST_AsBinary(ST_Force2D(");
            this.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append("))");
        } else {
            sql.append("ST_AsBinary(");
            this.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append(")");
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_Extent(\"").append(geometryColumn).append("\")");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException {
        Geometry envelope = (Geometry)rs.getObject(column);
        if (envelope != null) {
            return envelope.getEnvelopeInternal();
        }
        return new Envelope();
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        String typeName = columnMetaData.getString("TYPE_NAME");
        if ("uuid".equalsIgnoreCase(typeName)) {
            return UUID.class;
        }
        String gType = null;
        if (typeName.toLowerCase().startsWith("geometry")) {
            GeometryMetaData geomMetata;
            if (this.getH2GISVersion(cx).compareTo(V_1_5_0) <= 0) {
                String columnName = columnMetaData.getString("COLUMN_NAME");
                TableLocation tableLocation = new TableLocation(null, columnMetaData.getString("TABLE_SCHEM"), columnMetaData.getString("TABLE_NAME"), DBTypes.H2GIS);
                GeometryMetaData geomMetata2 = GeometryTableUtilities.getMetaData((Connection)cx, (TableLocation)tableLocation, (String)columnName);
                if (geomMetata2 != null) {
                    gType = geomMetata2.getGeometryType();
                }
            } else if (this.getH2GISVersion(cx).getMajor().equals(2) && (geomMetata = GeometryMetaData.getMetaDataFromTablePattern((String)typeName)) != null) {
                gType = geomMetata.getGeometryType();
            }
        } else {
            return null;
        }
        if (gType == null) {
            return Geometry.class;
        }
        Class<Geometry> geometryClass = TYPE_TO_CLASS_MAP.get(gType.toUpperCase());
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        int srid = 0;
        if (schemaName == null) {
            schemaName = "PUBLIC";
        }
        try {
            LOGGER.log(Level.FINE, "Geometry srid check; {0} ", "rien");
            srid = this.getSRID(cx, schemaName, tableName, columnName);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking the first geometry instead", e);
        }
        if (srid == 0) {
            try (Statement statement = cx.createStatement();){
                String sql = "SELECT ST_SRID(" + this.escapeName(columnName) + ") FROM " + this.escapeName(schemaName) + "." + this.escapeName(tableName) + " WHERE " + this.escapeName(columnName) + " IS NOT NULL LIMIT 1";
                try (ResultSet res = statement.executeQuery(sql);){
                    if (res.next()) {
                        srid = res.getInt(1);
                    }
                }
            }
        }
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement statement = null;
        ResultSet result = null;
        int dimension = 0;
        try {
            String sqlStatement;
            if (schemaName == null) {
                schemaName = "PUBLIC";
            }
            try {
                sqlStatement = "SELECT COORD_DIMENSION FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' AND F_TABLE_NAME = '" + tableName + "' AND F_GEOMETRY_COLUMN = '" + columnName + "'";
                LOGGER.log(Level.FINE, "Geometry srid check; {0} ", sqlStatement);
                statement = cx.createStatement();
                result = statement.executeQuery(sqlStatement);
                if (result.next()) {
                    dimension = result.getInt(1);
                }
                this.dataStore.closeSafe(result);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Failed to retrieve information about " + schemaName + "." + tableName + "." + columnName + " from the geometry_columns table, checking the first geometry instead", e);
            }
            finally {
                this.dataStore.closeSafe(result);
            }
            if (dimension == 0 && statement != null && (result = statement.executeQuery(sqlStatement = "SELECT ST_DIMENSION(\"" + columnName + "\") FROM \"" + schemaName + "\".\"" + tableName + "\" WHERE " + columnName + " IS NOT NULL LIMIT 1")).next()) {
                dimension = result.getInt(1);
            }
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            throw throwable;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Object sequenceName = tableName + "_" + columnName + "_SEQUENCE";
        sequenceName = ((String)sequenceName).toUpperCase();
        Statement st = cx.createStatement();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM INFORMATION_SCHEMA.SEQUENCES ");
            sql.append("WHERE SEQUENCE_NAME = '").append((String)sequenceName).append("'");
            this.dataStore.getLogger().fine(sql.toString());
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (rs.next()) {
                    Object object = sequenceName;
                    return object;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT NEXT VALUE FOR " + (String)(schemaName != null ? schemaName + "." : "") + sequenceName;
            if (this.getH2GISVersion(cx).compareTo(V_1_5_0) <= 0) {
                sql = "SELECT nextval('" + sequenceName + "')";
            }
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sequenceName = this.getSequenceForColumn(schemaName, tableName, columnName, cx);
            if (sequenceName == null) {
                Object var7_7 = null;
                return var7_7;
            }
            Object sql = "SELECT CURRENT VALUE FOR " + schemaName + "." + sequenceName;
            if (this.getH2GISVersion(cx).compareTo(V_1_5_0) <= 0) {
                sql = "SELECT lastval()";
            }
            this.dataStore.getLogger().fine((String)sql);
            ResultSet rs = st.executeQuery((String)sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
        mappings.put(UUID.class, 1111);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("GEOMETRY", Geometry.class);
        mappings.put("TEXT", String.class);
        mappings.put("INT8", Long.class);
        mappings.put("INT4", Integer.class);
        mappings.put("BOOL", Boolean.class);
        mappings.put("BIT", Boolean.class);
        mappings.put("CHARACTER", String.class);
        mappings.put("VARCHAR", String.class);
        mappings.put("VARCHAR_IGNORECASE", String.class);
        mappings.put("CHARACTER VARYING", String.class);
        mappings.put("LONGVARCHAR", String.class);
        mappings.put("FLOAT8", Double.class);
        mappings.put("INT", Integer.class);
        mappings.put("FLOAT4", Float.class);
        mappings.put("REAL", Float.class);
        mappings.put("INT2", Short.class);
        mappings.put("TIME", Time.class);
        mappings.put("TIMESTAMP", Timestamp.class);
        mappings.put("UUID", UUID.class);
        mappings.put("DATE", Date.class);
        mappings.put("JSON", String.class);
        mappings.put("DECFLOAT", Float.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(12, "VARCHAR");
        overrides.put(16, "BOOL");
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" SERIAL PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = schemaName != null ? schemaName : "PUBLIC";
        String tableName = featureType.getName().getLocalPart();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                Object geomType;
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)att;
                int srid = 0;
                if (gd.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)gd.getUserData().get("nativeSRID");
                } else if (gd.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                int dimensions = 2;
                if (gd.getUserData().get(Hints.COORDINATE_DIMENSION) != null) {
                    dimensions = (Integer)gd.getUserData().get(Hints.COORDINATE_DIMENSION);
                }
                if ((geomType = CLASS_TO_TYPE_MAP.get(gd.getType().getBinding())) == null) {
                    geomType = "GEOMETRY";
                }
                String sql = null;
                if (this.getH2GISVersion(cx).compareTo(V_1_5_0) <= 0) {
                    if (dimensions == 3) {
                        geomType = (String)geomType + "Z";
                    } else if (dimensions == 4) {
                        geomType = (String)geomType + "ZM";
                    } else if (dimensions > 4) {
                        throw new IllegalArgumentException("H2GIS only supports geometries with 2 , 3  dimensions, current value: " + dimensions);
                    }
                    sql = "ALTER TABLE " + this.escapeName(schemaName) + "." + this.escapeName(tableName) + " ALTER COLUMN " + this.escapeName(gd.getLocalName()) + " TYPE geometry (" + (String)geomType + ", " + srid + ");";
                    LOGGER.fine(sql);
                    st.execute(sql);
                    continue;
                }
                if (!this.getH2GISVersion(cx).getMajor().equals(2)) continue;
                if (dimensions == 3) {
                    geomType = (String)geomType + "Z";
                } else if (dimensions == 4) {
                    geomType = (String)geomType + "ZM";
                } else if (dimensions > 4) {
                    throw new IllegalArgumentException("H2GIS only supports geometries with 2 , 3  and 4 dimensions, current value: " + dimensions);
                }
                sql = "ALTER TABLE " + this.escapeName(schemaName) + "." + this.escapeName(tableName) + " ALTER COLUMN " + this.escapeName(gd.getLocalName()) + " TYPE geometry (" + (String)geomType + ", " + srid + ");";
                LOGGER.fine(sql);
                st.execute(sql);
            }
            if (!cx.getAutoCommit()) {
                cx.commit();
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) {
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) {
        if (value == null || value.isEmpty()) {
            sql.append("NULL");
        } else {
            WKTWriter writer = new WKTWriter(dimension);
            String wkt = writer.write(value);
            sql.append("ST_GeomFromText('").append(wkt).append("', ").append(srid).append(")");
        }
    }

    public FilterToSQL createFilterToSQL() {
        H2GISFilterToSQL sql = new H2GISFilterToSQL();
        sql.setFunctionEncodingEnabled(this.functionEncodingEnabled);
        return sql;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT ").append(limit);
            if (offset > 0) {
                sql.append(" OFFSET ").append(offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET ").append(offset);
        }
    }

    public void encodeValue(Object value, Class type, StringBuffer sql) {
        if (byte[].class == type) {
            byte[] b = (byte[])value;
            if (value != null) {
                sql.append("'");
                for (byte item : b) {
                    sql.append(Integer.toString((item & 0xFF) + 256, 16).substring(1));
                }
                sql.append("'");
            } else {
                sql.append("NULL");
            }
        } else {
            super.encodeValue(value, type, sql);
        }
    }

    public int getDefaultVarcharSize() {
        return -1;
    }

    public String[] getDesiredTablesType() {
        return new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "SYNONYM", "TABLE LINK", "EXTERNAL", "BASE TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY"};
    }

    public Geometry decodeGeometryValue(GeometryDescriptor gd, ResultSet rs, String column, GeometryFactory gf, Connection cnctn, Hints hints) throws SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        Geometry geom = ValueGeometry.get((byte[])bytes).getGeometry();
        if (geom == null) {
            return null;
        }
        return geom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException {
        if (!this.estimatedExtentsEnabled) {
            return null;
        }
        String tableName = featureType.getTypeName();
        if (this.dataStore.getVirtualTables().get(tableName) != null) {
            return null;
        }
        TableLocation tableLocation = new TableLocation(null, schema, tableName, DBTypes.H2GIS);
        ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
        Savepoint savePoint = null;
        try {
            if (!cx.getAutoCommit()) {
                savePoint = cx.setSavepoint();
            }
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                Envelope env;
                if (!(att instanceof GeometryDescriptor) || (env = GeometryTableUtilities.getEstimatedExtent((Connection)cx, (TableLocation)tableLocation, (String)att.getName().getLocalPart()).getEnvelopeInternal()).isNull()) continue;
                SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
                result.add(new ReferencedEnvelope(env, (CoordinateReferenceSystem)flatCRS));
            }
        }
        catch (SQLException e) {
            if (savePoint != null) {
                cx.rollback(savePoint);
            }
            LOGGER.log(Level.WARNING, "Failed to use ST_EstimatedExtent , falling back on envelope aggregation", e);
            List<ReferencedEnvelope> list = null;
            return list;
        }
        finally {
            if (savePoint != null) {
                cx.releaseSavepoint(savePoint);
            }
        }
        return result;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getH2GISVersion(Connection conn) throws SQLException {
        if (this.h2gisVersion == null) {
            ResultSet rs;
            Statement st;
            block3: {
                st = null;
                rs = null;
                try {
                    st = conn.createStatement();
                    rs = st.executeQuery("select H2GISversion()");
                    if (!rs.next()) break block3;
                    this.h2gisVersion = new Version(rs.getString(1));
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe(st);
                    throw throwable;
                }
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
        }
        return this.h2gisVersion;
    }

    public int getSRID(Connection connection, String schema, String table, String geometryColumnName) throws SQLException {
        int srid = 0;
        try (ResultSet geomResultSet = GeometryTableUtilities.getGeometryColumnsView((Connection)connection, (String)"", (String)schema, (String)table, (String)geometryColumnName);){
            if (geomResultSet.next()) {
                srid = geomResultSet.getInt("srid");
            }
        }
        return srid;
    }

    public Class<?> getMapping(String sqlTypeName) {
        if (sqlTypeName.toLowerCase().startsWith("geometry")) {
            return this.findGeometryClass(sqlTypeName);
        }
        return null;
    }

    public Class<?> findGeometryClass(String geometryName) {
        Class<Geometry> geometryClass = Geometry.class;
        Matcher matcher = GEOMETRY_TABLE_PATTERN.matcher(geometryName);
        if (matcher.find()) {
            String type = matcher.group(1);
            if (type == null) {
                return geometryClass;
            }
            switch (type = type.replaceAll(" ", "").replaceAll("\"", "")) {
                case "POINT": {
                    geometryClass = Point.class;
                    break;
                }
                case "LINESTRING": {
                    geometryClass = LineString.class;
                    break;
                }
                case "POLYGON": {
                    geometryClass = Polygon.class;
                    break;
                }
                case "MULTIPOINT": {
                    geometryClass = MultiPoint.class;
                    break;
                }
                case "MULTILINESTRING": {
                    geometryClass = MultiLineString.class;
                    break;
                }
                case "MULTIPOLYGON": {
                    geometryClass = MultiPolygon.class;
                    break;
                }
                case "GEOMETRYCOLLECTION": {
                    geometryClass = GeometryCollection.class;
                    break;
                }
                case "POINTZ": {
                    geometryClass = Point.class;
                    break;
                }
                case "LINESTRINGZ": {
                    geometryClass = LineString.class;
                    break;
                }
                case "POLYGONZ": {
                    geometryClass = Polygon.class;
                    break;
                }
                case "MULTIPOINTZ": {
                    geometryClass = MultiPoint.class;
                    break;
                }
                case "MULTILINESTRINGZ": {
                    geometryClass = MultiLineString.class;
                    break;
                }
                case "MULTIPOLYGONZ": {
                    geometryClass = MultiPolygon.class;
                    break;
                }
                case "GEOMETRYCOLLECTIONZ": {
                    geometryClass = GeometryCollection.class;
                    break;
                }
                case "POINTM": {
                    geometryClass = Point.class;
                    break;
                }
                case "LINESTRINGM": {
                    geometryClass = LineString.class;
                    break;
                }
                case "POLYGONM": {
                    geometryClass = Polygon.class;
                    break;
                }
                case "MULTIPOINTM": {
                    geometryClass = MultiPoint.class;
                    break;
                }
                case "MULTILINESTRINGM": {
                    geometryClass = MultiLineString.class;
                    break;
                }
                case "MULTIPOLYGONM": {
                    geometryClass = MultiPolygon.class;
                    break;
                }
                case "GEOMETRYCOLLECTIONM": {
                    geometryClass = GeometryCollection.class;
                    break;
                }
                case "POINTZM": {
                    geometryClass = Point.class;
                    break;
                }
                case "LINESTRINGZM": {
                    geometryClass = LineString.class;
                    break;
                }
                case "POLYGONZM": {
                    geometryClass = Polygon.class;
                    break;
                }
                case "MULTIPOINTZM": {
                    geometryClass = MultiPoint.class;
                    break;
                }
                case "MULTILINESTRINGZM": {
                    geometryClass = MultiLineString.class;
                    break;
                }
                case "MULTIPOLYGONZM": {
                    geometryClass = MultiPolygon.class;
                    break;
                }
                case "GEOMETRYCOLLECTIONZM": {
                    geometryClass = GeometryCollection.class;
                    break;
                }
            }
            return geometryClass;
        }
        return geometryClass;
    }

    public static void initSpatialFunctions(Connection cx) throws SQLException {
        if (!JDBCUtilities.tableExists((Connection)cx, (TableLocation)new TableLocation("GEOMETRY_COLUMNS"))) {
            H2GISFunctions.load((Connection)cx);
        }
    }
}

