/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.geotools;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.jdbc.datasource.DBCPDataSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;
import org.h2gis.geotools.H2GISDialect;
import org.h2gis.geotools.H2GISPSDialect;

public class H2GISDataStoreFactory
extends JDBCDataStoreFactory {
    static final Logger LOGGER = Logging.getLogger(H2GISDataStoreFactory.class);
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"h2gis");
    public static final DataAccessFactory.Param ASSOCIATIONS = new DataAccessFactory.Param("Associations", Boolean.class, "Associations", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param(JDBCDataStoreFactory.HOST.key, JDBCDataStoreFactory.HOST.type, JDBCDataStoreFactory.HOST.description, false, JDBCDataStoreFactory.HOST.sample);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param(JDBCDataStoreFactory.PORT.key, JDBCDataStoreFactory.PORT.type, JDBCDataStoreFactory.PORT.description, false, (Object)9902);
    public static final DataAccessFactory.Param AUTO_SERVER = new DataAccessFactory.Param("autoserver", Boolean.class, "Activate AUTO_SERVER mode to share the database access", false, (Object)true);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param PREPARED_STATEMENTS = new DataAccessFactory.Param("preparedStatements", Boolean.class, "Use prepared statements", false, (Object)Boolean.FALSE);
    public static final DataAccessFactory.Param ENCODE_FUNCTIONS = new DataAccessFactory.Param("encode functions", Boolean.class, "set to true to have a set of filter functions be translated directly in SQL. Due to differences in the type systems the result might not be the same as evaluating them in memory, including the SQL failing with errors while the in memory version works fine. However this allows to push more of the filter into the database, increasing performance.the H2GIS table.", false, (Object)Boolean.TRUE, (Map)new KVP(new Object[]{"level", "advanced"}));
    private File baseDirectory = null;

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected void setupParameters(Map<String, Object> parameters) {
        super.setupParameters(parameters);
        parameters.remove(JDBCDataStoreFactory.HOST.key);
        parameters.remove(JDBCDataStoreFactory.PORT.key);
        parameters.put(H2GISDataStoreFactory.HOST.key, HOST);
        parameters.put(H2GISDataStoreFactory.PORT.key, PORT);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.remove(H2GISDataStoreFactory.PASSWD.key);
        parameters.put(H2GISDataStoreFactory.USER.key, USER);
        parameters.put(H2GISDataStoreFactory.PASSWD.key, PASSWD);
        parameters.put(H2GISDataStoreFactory.ASSOCIATIONS.key, ASSOCIATIONS);
        parameters.put(H2GISDataStoreFactory.DBTYPE.key, DBTYPE);
        parameters.put(H2GISDataStoreFactory.AUTO_SERVER.key, AUTO_SERVER);
        parameters.put(H2GISDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(H2GISDataStoreFactory.PREPARED_STATEMENTS.key, PREPARED_STATEMENTS);
        parameters.put(H2GISDataStoreFactory.ENCODE_FUNCTIONS.key, ENCODE_FUNCTIONS);
    }

    public String getDisplayName() {
        return "H2GIS";
    }

    public String getDescription() {
        return "H2GIS Database";
    }

    protected String getDatabaseID() {
        return (String)H2GISDataStoreFactory.DBTYPE.sample;
    }

    protected String getDriverClassName() {
        return "org.h2.Driver";
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore, Map<String, ?> params) {
        H2GISDialect dialect;
        block3: {
            dialect = new H2GISDialect(dataStore);
            try {
                if (Boolean.TRUE.equals(PREPARED_STATEMENTS.lookUp(params))) {
                    return new H2GISPSDialect(dataStore, dialect);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, "Failed to lookup prepared statement parameter, continuining with non prepared dialect", e);
            }
        }
        return dialect;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new H2GISDialect(dataStore);
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        String autoServerSpec;
        String database = (String)DATABASE.lookUp(params);
        String host = (String)HOST.lookUp(params);
        Boolean autoServer = (Boolean)AUTO_SERVER.lookUp(params);
        String string = autoServerSpec = Boolean.TRUE.equals(autoServer) ? ";AUTO_SERVER=TRUE" : "";
        if (host != null && !host.equals("")) {
            Integer port = (Integer)PORT.lookUp(params);
            if (port != null) {
                return "jdbc:h2:tcp://" + host + ":" + port + "/" + database;
            }
            return "jdbc:h2:tcp://" + host + "/" + database;
        }
        if (this.baseDirectory == null) {
            return "jdbc:h2:./" + database + autoServerSpec;
        }
        String location = !new File(database).isAbsolute() ? new File(this.baseDirectory, database).getAbsolutePath() : database;
        return "jdbc:h2:file:" + location + autoServerSpec;
    }

    protected DataSource createDataSource(Map<String, ?> params, SQLDialect dialect) throws IOException {
        String password;
        BasicDataSource dataSource = new BasicDataSource();
        String jdbcURl = this.getJDBCUrl(params);
        dataSource.setUrl(jdbcURl);
        String username = (String)USER.lookUp(params);
        if (username != null) {
            dataSource.setUsername(username);
        }
        if ((password = (String)PASSWD.lookUp(params)) != null) {
            dataSource.setPassword(password);
        }
        dataSource.setDriverClassName("org.h2.Driver");
        dataSource.setPoolPreparedStatements(false);
        if (!jdbcURl.contains("h2:tcp")) {
            try (Connection cx = dataSource.getConnection();){
                H2GISDialect.initSpatialFunctions(cx);
            }
            catch (SQLException e) {
                throw new IOException("Failed to create the target database", e);
            }
        }
        return new DBCPDataSource(dataSource);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map<String, ?> params) throws IOException {
        Boolean encodeFunctions;
        SQLDialect genericDialect = dataStore.getSQLDialect();
        H2GISDialect dialect = genericDialect instanceof H2GISPSDialect ? ((H2GISPSDialect)genericDialect).getDelegate() : (H2GISDialect)dataStore.getSQLDialect();
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        Boolean foreignKeys = (Boolean)ASSOCIATIONS.lookUp(params);
        if (foreignKeys != null) {
            dataStore.setAssociations(foreignKeys.booleanValue());
        }
        dialect.setFunctionEncodingEnabled((encodeFunctions = (Boolean)ENCODE_FUNCTIONS.lookUp(params)) == null || encodeFunctions != false);
        Boolean usePs = (Boolean)PREPARED_STATEMENTS.lookUp(params);
        if (Boolean.TRUE.equals(usePs)) {
            dataStore.setSQLDialect((SQLDialect)new H2GISPSDialect(dataStore, dialect));
        }
        return dataStore;
    }

    protected String getValidationQuery() {
        return "select now()";
    }
}

