/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.geotools;

import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.h2gis.geotools.H2GISFilterToSQLHelper;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class H2GISFilterToSQL
extends FilterToSQL {
    H2GISFilterToSQLHelper h2GISFilterToSQLHelper = new H2GISFilterToSQLHelper(this);
    private boolean functionEncodingEnabled;

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        this.out.write("ST_GeomFromText('");
        this.out.write(geom.toText());
        if (this.currentSRID == null && this.currentGeometry != null) {
            this.out.write("', ST_SRID(\"" + this.currentGeometry.getLocalName() + "\"))");
        } else {
            this.out.write("', " + this.currentSRID + ")");
        }
    }

    protected FilterCapabilities createFilterCapabilities() {
        return H2GISFilterToSQLHelper.createFilterCapabilities(this.functionEncodingEnabled, super.createFilterCapabilities());
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.h2GISFilterToSQLHelper.out = this.out;
        return this.h2GISFilterToSQLHelper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        this.h2GISFilterToSQLHelper.out = this.out;
        return this.h2GISFilterToSQLHelper.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        this.h2GISFilterToSQLHelper.out = this.out;
        try {
            this.encodingFunction = true;
            boolean encoded = this.h2GISFilterToSQLHelper.visitFunction(function, extraData);
            this.encodingFunction = false;
            if (encoded) {
                return extraData;
            }
            return super.visit(function, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFunctionName(Function function) {
        return H2GISFilterToSQLHelper.getFunctionName(function);
    }

    protected String cast(String encodedProperty, Class target) {
        return this.h2GISFilterToSQLHelper.cast(encodedProperty, target);
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }
}

