/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.db2.DB2DialectInfo;
import org.geotools.data.db2.DB2Util;
import org.geotools.data.db2.DB2WKBReader;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class DB2SQLDialect
extends SQLDialect {
    private static Integer GEOMETRY = 9001;
    private static Integer GEOMETRYCOLL = 9002;
    private static Integer POINT = 9003;
    private static Integer MULTIPOINT = 9004;
    private static Integer LINESTRING = 9005;
    private static Integer MULTILINESTRING = 9006;
    private static Integer POLY = 9007;
    private static Integer MULTIPOLY = 9008;
    private static String POINT_STR = "\"DB2GSE\".\"ST_POINT\"";
    private static String LINESTRING_STR = "\"DB2GSE\".\"ST_LINESTRING\"";
    private static String POLY_STR = "\"DB2GSE\".\"ST_POLYGON\"";
    private static String MULTIPOINT_STR = "\"DB2GSE\".\"ST_MULTIPOINT\"";
    private static String MULTILINESTRING_STR = "\"DB2GSE\".\"ST_MULTILINESTRING\"";
    private static String MULTIPOLY_STR = "\"DB2GSE\".\"ST_MULTIPOLYGON\"";
    private static String GEOMETRY_STR = "\"DB2GSE\".\"ST_GEOMETRY\"";
    private static String GEOMETRYCOLL_STR = "\"DB2GSE\".\"ST_GEOMCOLLECTION\"";
    static String SELECTIVITY_CLAUSE = "SELECTIVITY 0.000001 ";
    private static String DEFAULT_SRS_NAME = "DEFAULT_SRS";
    private static Integer DEFAULT_SRS_ID = 0;
    private boolean looseBBOXEnabled;
    private boolean useSelectivity;
    private static String SELECT_SRSID_WITH_SCHEMA = "select SRS_ID from DB2GSE.ST_GEOMETRY_COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME = ? and COLUMN_NAME = ?";
    private static String SELECT_SRSID_WITHOUT_SCHEMA = "select SRS_ID from DB2GSE.ST_GEOMETRY_COLUMNS where  TABLE_NAME = ? and COLUMN_NAME = ?";
    private static String SELECT_CRS_WKT = "select definition,organization,organization_coordsys_id from db2gse.st_coordinate_systems where coordsys_name = (select coordsys_name from db2gse.st_spatial_reference_systems where srs_id=?)";
    private static String SELECT_SRS_NAME_FROM_ID = "select srs_name from db2gse.st_spatial_reference_systems where srs_id = ?";
    private String SELECT_SRS_NAME_FROM_ORG = "select srs_name,srs_id from db2gse.st_spatial_reference_systems where organization = ? and organization_coordsys_id=?";
    private static String SELECT_ROWNUMBER = "select * from sysibm.sysdummy1 where rownum = 1";
    private Boolean isRowNumberSupported = null;
    private static String SELECT_LIMITOFFSET = "select * from sysibm.sysdummy1 limit 0,1";
    private Boolean isLimitOffsetSupported = null;
    private static String ROWNUMBER_MESSAGE = "Using Oracle ROWNUM for paging support";
    private static String LIMITOFFSET_MESSAGE = "Using LIMIT OFFSET for paging support";
    private String NOPAGESUPPORT_MESSAGE = "DB2 handles paged select statements inefficiently\nTry to set MySql or Oracle compatibility mode\ndbstop\ndb2set DB2_COMPATIBILITY_VECTOR=MYS\ndb2start\n";
    private DB2DialectInfo db2DialectInfo;
    private boolean functionEncodingEnabled;

    public DB2SQLDialect(JDBCDataStore dataStore, DB2DialectInfo info) {
        super(dataStore);
        this.db2DialectInfo = info;
    }

    public DB2DialectInfo getDb2DialectInfo() {
        return this.db2DialectInfo;
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        block21: {
            CoordinateReferenceSystem crs;
            String wkt;
            block20: {
                String org = null;
                wkt = null;
                int orgid = 0;
                try (PreparedStatement ps = cx.prepareStatement(SELECT_CRS_WKT);){
                    ps.setInt(1, srid);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            wkt = rs.getString(1);
                            org = rs.getString(2);
                            orgid = rs.getInt(3);
                        }
                    }
                }
                if (orgid != 0 && org != null) {
                    try {
                        crs = CRS.decode((String)(org + ":" + orgid), (boolean)true);
                        return crs;
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block20;
                        LOGGER.log(Level.WARNING, "Could not decode " + org + ":" + orgid + " using the geotools database", e);
                    }
                }
            }
            if (wkt != null) {
                try {
                    crs = CRS.parseWKT((String)wkt);
                    return crs;
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block21;
                    LOGGER.log(Level.WARNING, "Could not decode db2 wkt definition for " + srid);
                }
            }
        }
        return null;
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        super.encodePrimaryKey(column, sql);
        sql.append(" NOT NULL");
    }

    public String getGeometryTypeName(Integer type) {
        if (GEOMETRY.equals(type)) {
            return GEOMETRY_STR;
        }
        if (GEOMETRYCOLL.equals(type)) {
            return GEOMETRYCOLL_STR;
        }
        if (POINT.equals(type)) {
            return POINT_STR;
        }
        if (MULTIPOINT.equals(type)) {
            return MULTIPOINT_STR;
        }
        if (LINESTRING.equals(type)) {
            return LINESTRING_STR;
        }
        if (MULTILINESTRING.equals(type)) {
            return MULTILINESTRING_STR;
        }
        if (POLY.equals(type)) {
            return POLY_STR;
        }
        if (MULTIPOLY.equals(type)) {
            return MULTIPOLY_STR;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = null;
        PreparedStatement stmt = null;
        try {
            if (schemaName != null) {
                stmt = cx.prepareStatement(SELECT_SRSID_WITH_SCHEMA);
                stmt.setString(1, schemaName);
                stmt.setString(2, tableName);
                stmt.setString(3, columnName);
            } else {
                stmt = cx.prepareStatement(SELECT_SRSID_WITHOUT_SCHEMA);
                stmt.setString(1, tableName);
                stmt.setString(2, columnName);
            }
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                if (rs.next()) {
                    srid = (Integer)rs.getObject(1);
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe((Statement)stmt);
        }
        return srid;
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.encodeGeometryColumn(gatt, prefix, sql);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, StringBuffer sql) {
        sql.append("db2gse.ST_AsBinary(");
        this.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("min(db2gse.st_minx(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
        sql.append(",min(db2gse.st_miny(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
        sql.append(",max(db2gse.st_maxx(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
        sql.append(",max(db2gse.st_maxy(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("))");
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ArrayList<ReferencedEnvelope> result;
        ResultSet rs;
        Statement st;
        block21: {
            List<ReferencedEnvelope> list;
            block20: {
                List<ReferencedEnvelope> list2;
                block19: {
                    List<ReferencedEnvelope> list3;
                    block18: {
                        List<ReferencedEnvelope> list4;
                        block17: {
                            if (!this.getDb2DialectInfo().isSupportingPrecalculatedExtents()) {
                                return null;
                            }
                            if (this.dataStore.getVirtualTables().get(featureType.getTypeName()) != null) {
                                return null;
                            }
                            if (schema == null) return null;
                            if ("".equals(schema)) {
                                return null;
                            }
                            String tableName = featureType.getTypeName();
                            st = null;
                            rs = null;
                            result = new ArrayList<ReferencedEnvelope>();
                            try {
                                st = cx.createStatement();
                                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                                    if (!(att instanceof GeometryDescriptor)) continue;
                                    StringBuffer sql = new StringBuffer();
                                    sql.append("select min_x,min_y,max_x,max_y from db2gse.st_geometry_columns where  TABLE_SCHEMA='");
                                    sql.append(schema).append("' AND TABLE_NAME='");
                                    sql.append(tableName).append("' AND COLUMN_NAME='");
                                    sql.append(att.getName().getLocalPart()).append("'");
                                    LOGGER.log(Level.FINE, "Getting the full extent of the table using optimized search: {0}", sql);
                                    rs = st.executeQuery(sql.toString());
                                    if (!rs.next()) continue;
                                    Double min_x = rs.getDouble(1);
                                    if (rs.wasNull()) {
                                        list4 = null;
                                        this.dataStore.closeSafe(rs);
                                        break block17;
                                    }
                                    Double min_y = rs.getDouble(2);
                                    if (rs.wasNull()) {
                                        list3 = null;
                                        this.dataStore.closeSafe(rs);
                                        break block18;
                                    }
                                    Double max_x = rs.getDouble(3);
                                    if (rs.wasNull()) {
                                        list2 = null;
                                        this.dataStore.closeSafe(rs);
                                        break block19;
                                    }
                                    Double max_y = rs.getDouble(4);
                                    if (rs.wasNull()) {
                                        list = null;
                                        this.dataStore.closeSafe(rs);
                                        break block20;
                                    }
                                    Polygon geometry = new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(min_x.doubleValue(), min_y.doubleValue()), new Coordinate(min_x.doubleValue(), max_y.doubleValue()), new Coordinate(max_x.doubleValue(), max_y.doubleValue()), new Coordinate(max_x.doubleValue(), min_y.doubleValue()), new Coordinate(min_x.doubleValue(), min_y.doubleValue())});
                                    ReferencedEnvelope env = JTS.bounds((Geometry)geometry, (CoordinateReferenceSystem)((GeometryDescriptor)att).getCoordinateReferenceSystem());
                                    if (env == null || env.isNull()) continue;
                                    result.add(env);
                                }
                                this.dataStore.closeSafe(rs);
                                break block21;
                            }
                            catch (SQLException e) {
                                LOGGER.log(Level.WARNING, "Failed to use extent from DB2GSE.ST_GEOMETRY_COLUMNS, falling back on envelope aggregation", e);
                                List<ReferencedEnvelope> list5 = null;
                                return list5;
                            }
                        }
                        this.dataStore.closeSafe(st);
                        return list4;
                    }
                    this.dataStore.closeSafe(st);
                    return list3;
                }
                this.dataStore.closeSafe(st);
                return list2;
            }
            this.dataStore.closeSafe(st);
            return list;
        }
        this.dataStore.closeSafe(st);
        return result;
        finally {
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe(st);
        }
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        if (column % 4 != 1) {
            return null;
        }
        double minX = rs.getDouble(column);
        if (rs.wasNull()) {
            return null;
        }
        return new Envelope(minX, rs.getDouble(3), rs.getDouble(2), rs.getDouble(4));
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String name, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(name);
        return this.decodeGeometryValueFromBytes(factory, bytes);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        return this.decodeGeometryValueFromBytes(factory, bytes);
    }

    private Geometry decodeGeometryValueFromBytes(GeometryFactory factory, byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        try {
            return new DB2WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            String msg = "Error decoding wkb";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Point.class, POINT);
        mappings.put(LineString.class, LINESTRING);
        mappings.put(LinearRing.class, LINESTRING);
        mappings.put(Polygon.class, POLY);
        mappings.put(MultiPoint.class, MULTIPOINT);
        mappings.put(MultiLineString.class, MULTILINESTRING);
        mappings.put(MultiPolygon.class, MULTIPOLY);
        mappings.put(Geometry.class, GEOMETRY);
        mappings.put(GeometryCollection.class, GEOMETRYCOLL);
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(GEOMETRY, Geometry.class);
        mappings.put(GEOMETRYCOLL, GeometryCollection.class);
        mappings.put(POINT, Point.class);
        mappings.put(MULTIPOINT, MultiPoint.class);
        mappings.put(LINESTRING, LineString.class);
        mappings.put(MULTILINESTRING, MultiLineString.class);
        mappings.put(POLY, Polygon.class);
        mappings.put(MULTIPOLY, Polygon.class);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put(POINT_STR, Point.class);
        mappings.put(LINESTRING_STR, LineString.class);
        mappings.put(POLY_STR, Polygon.class);
        mappings.put(MULTIPOINT_STR, MultiPoint.class);
        mappings.put(MULTILINESTRING_STR, MultiLineString.class);
        mappings.put(MULTIPOLY_STR, MultiPolygon.class);
        mappings.put(GEOMETRY_STR, Geometry.class);
        mappings.put(GEOMETRYCOLL_STR, GeometryCollection.class);
    }

    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        if (featureType.getGeometryDescriptor() == null) {
            return;
        }
        String tableName = featureType.getTypeName();
        String columnName = featureType.getGeometryDescriptor().getName().toString();
        for (AttributeDescriptor attr : featureType.getAttributeDescriptors()) {
            if (!(attr instanceof GeometryDescriptor)) continue;
            GeometryDescriptor gDescr = (GeometryDescriptor)attr;
            String srsName = null;
            Integer srsId = (Integer)gDescr.getUserData().get("nativeSRID");
            if (srsId != null) {
                try (PreparedStatement ps1 = cx.prepareStatement(SELECT_SRS_NAME_FROM_ID);){
                    ps1.setInt(1, srsId);
                    try (ResultSet rs = ps1.executeQuery();){
                        if (rs.next()) {
                            srsName = rs.getString(1);
                        }
                    }
                }
            }
            if (srsName == null && gDescr.getCoordinateReferenceSystem() != null) {
                for (ReferenceIdentifier ident : gDescr.getCoordinateReferenceSystem().getIdentifiers()) {
                    try (PreparedStatement ps1 = cx.prepareStatement(this.SELECT_SRS_NAME_FROM_ORG);){
                        ps1.setString(1, ident.getCodeSpace());
                        ps1.setInt(2, Integer.valueOf(ident.getCode()));
                        try (ResultSet rs = ps1.executeQuery();){
                            if (rs.next()) {
                                srsName = rs.getString(1);
                                srsId = rs.getInt(2);
                            }
                        }
                    }
                    if (srsName == null) continue;
                    break;
                }
            }
            if (srsName == null) {
                srsName = DEFAULT_SRS_NAME;
                srsId = DEFAULT_SRS_ID;
            }
            DB2Util.executeRegister(schemaName, tableName, columnName, srsName, cx);
            gDescr.getUserData().put("nativeSRID", srsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = tableName + "_" + columnName + "_SEQUENCE";
        StringBuffer sql = new StringBuffer("SELECT SEQNAME FROM SYSCAT.SEQUENCES WHERE ");
        if (schemaName != null) {
            sql.append("SEQSCHEMA ='");
            sql.append(schemaName);
            sql.append("' AND ");
        }
        sql.append("SEQNAME = '");
        sql.append(sequenceName);
        sql.append("'");
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (rs.next()) {
                    String string = sequenceName;
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(this.encodeNextSequenceValue(schemaName, sequenceName));
        sql.append(" from sysibm.sysdummy1");
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                if (!rs.next()) {
                    throw new SQLException("Could not get next value for sequence");
                }
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        StringBuffer sql = new StringBuffer("next value for ");
        if (schemaName != null) {
            this.encodeSchemaName(schemaName, sql);
            sql.append(".");
        }
        this.encodeTableName(sequenceName, sql);
        return sql.toString();
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return true;
    }

    public boolean isLimitOffsetSupported() {
        boolean firstCall;
        boolean bl = firstCall = this.isLimitOffsetSupported == null && this.isRowNumberSupported == null;
        if (this.isLimitOffsetSupported == null) {
            this.setIsLimitOffsetSupported();
        }
        if (this.isLimitOffsetSupported.booleanValue()) {
            return true;
        }
        if (this.isRowNumberSupported == null) {
            this.setIsRowNumberSupported();
        }
        if (this.isRowNumberSupported.booleanValue()) {
            return true;
        }
        if (firstCall) {
            LOGGER.warning(this.NOPAGESUPPORT_MESSAGE);
        }
        return false;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (Boolean.TRUE.equals(this.isLimitOffsetSupported)) {
            if (limit >= 0 && limit < Integer.MAX_VALUE) {
                if (offset > 0) {
                    sql.append(" LIMIT " + offset + ", " + limit);
                } else {
                    sql.append(" LIMIT " + limit);
                }
            } else if (offset > 0) {
                sql.append(" LIMIT " + offset + ", 2147483640");
            }
            return;
        }
        if (Boolean.TRUE.equals(this.isRowNumberSupported)) {
            if (offset == 0) {
                sql.insert(0, "SELECT * FROM (");
                sql.append(") WHERE ROWNUM <= " + limit);
            } else {
                long max = limit == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)(limit + offset);
                sql.insert(0, "SELECT * FROM (SELECT A.*, ROWNUM RNUM FROM ( ");
                sql.append(") A WHERE ROWNUM <= " + max + ")");
                sql.append("WHERE RNUM > " + offset);
            }
        }
    }

    private void setIsRowNumberSupported() {
        try (Connection con = this.dataStore.getDataSource().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_ROWNUMBER);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                this.isRowNumberSupported = Boolean.TRUE;
            }
            LOGGER.info(ROWNUMBER_MESSAGE);
        }
        catch (SQLException ex) {
            this.isRowNumberSupported = Boolean.FALSE;
        }
    }

    private void setIsLimitOffsetSupported() {
        try (Connection con = this.dataStore.getDataSource().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_LIMITOFFSET);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                this.isLimitOffsetSupported = Boolean.TRUE;
            }
            LOGGER.info(LIMITOFFSET_MESSAGE);
        }
        catch (SQLException ex) {
            this.isLimitOffsetSupported = Boolean.FALSE;
        }
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        sql.append("db2gse.ST_AsBinary(db2gse.st_Generalize(");
        this.encodeColumnName(null, gatt.getLocalName(), sql);
        sql.append(",").append(distance);
        sql.append("))");
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        if (this.isGeomGeneralizationSupported()) {
            LOGGER.info("GEOMETRY_GENERALIZATION support: YES");
            hints.add(Hints.GEOMETRY_GENERALIZATION);
        } else {
            LOGGER.info("GEOMETRY_GENERALIZATION support: NO");
        }
    }

    private boolean isGeomGeneralizationSupported() {
        DB2DialectInfo info = this.getDb2DialectInfo();
        if (info.getProductVersion().startsWith("DSN")) {
            return false;
        }
        if (info.getProductName().startsWith("Informix")) {
            return false;
        }
        if (!info.getProductVersion().startsWith("SQL")) {
            return false;
        }
        if (info.getMajorVersion() > 9) {
            return true;
        }
        if (info.getMajorVersion() < 9) {
            return false;
        }
        if (info.getMinorVersion() > 7) {
            return true;
        }
        if (info.getMinorVersion() < 5) {
            return false;
        }
        if (info.getProductVersion().length() < 8) {
            return false;
        }
        String fp = info.getProductVersion().substring(7);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < fp.length() && Character.isDigit(fp.charAt(i)); ++i) {
            buff.append(fp.charAt(i));
        }
        if (buff.length() == 0) {
            return false;
        }
        int fpNumber = Integer.parseInt(buff.toString());
        if (info.getMinorVersion() == 5 && fpNumber >= 5) {
            return true;
        }
        return info.getMinorVersion() == 7 && fpNumber >= 1;
    }

    public boolean isFunctionEncodingEnabled() {
        return this.functionEncodingEnabled;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isUseSelectivity() {
        return this.useSelectivity;
    }

    public void setUseSelectivity(boolean useSelectivity) {
        this.useSelectivity = useSelectivity;
    }

    protected boolean supportsSchemaForIndex() {
        return true;
    }

    public boolean canGroupOnGeometry() {
        return false;
    }
}

