/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.lang.reflect.Method;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class DB2ClobConverterFactory
implements ConverterFactory {
    DB2ClobConverter converter = new DB2ClobConverter();
    static final Class<?> DB2_CLOB;
    static final Method DB2_GET_SUBSTRING;
    static final Method DB2_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (DB2_CLOB == null) {
            return null;
        }
        if (!String.class.equals(target)) {
            return null;
        }
        if (!DB2_CLOB.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> db2ClobClass = null;
        try {
            db2ClobClass = Class.forName("com.ibm.db2.jcc.DB2Clob");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (db2ClobClass == null) {
            DB2_CLOB = null;
            DB2_GET_SUBSTRING = null;
            DB2_LENGTH = null;
        } else {
            try {
                DB2_CLOB = db2ClobClass;
                DB2_LENGTH = DB2_CLOB.getMethod("length", new Class[0]);
                DB2_GET_SUBSTRING = DB2_CLOB.getMethod("getSubString", Long.TYPE, Integer.TYPE);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the db2 clob converter", e);
            }
        }
    }

    class DB2ClobConverter
    implements Converter {
        DB2ClobConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)DB2_LENGTH.invoke(source, new Object[0])).intValue();
            return (T)DB2_GET_SUBSTRING.invoke(source, 1L, length);
        }
    }
}

