/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.util.Assert;

public class DB2WKBWriter {
    private int outputDimension = 2;
    private int byteOrder;
    private ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
    private OutStream byteArrayOutStream = new OutputStreamOutStream((OutputStream)this.byteArrayOS);
    private byte[] buf = new byte[8];
    private boolean hasOGCWkbZTyps;

    public static final int guessCoordinateDimension(Geometry g) {
        DimensionCoordFilter filter = new DimensionCoordFilter();
        g.apply((CoordinateFilter)filter);
        return filter.getDimension();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (byte b : bytes) {
            buf.append(DB2WKBWriter.toHexDigit(b >> 4 & 0xF));
            buf.append(DB2WKBWriter.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public DB2WKBWriter(boolean hasOGCWkbZTyps) {
        this(1, hasOGCWkbZTyps);
    }

    public DB2WKBWriter(int byteOrder, boolean hasOGCWkbZTyps) {
        this.byteOrder = byteOrder;
        this.hasOGCWkbZTyps = hasOGCWkbZTyps;
        if (this.outputDimension < 2 || this.outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public byte[] write(Geometry geom) {
        try {
            this.byteArrayOS.reset();
            this.write(geom, this.byteArrayOutStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.byteArrayOS.toByteArray();
    }

    public void write(Geometry geom, OutStream os) throws IOException {
        this.outputDimension = DB2WKBWriter.guessCoordinateDimension(geom);
        if (geom instanceof Point) {
            this.writePoint((Point)geom, os);
        } else if (geom instanceof LineString) {
            this.writeLineString((LineString)geom, os);
        } else if (geom instanceof Polygon) {
            this.writePolygon((Polygon)geom, os);
        } else if (geom instanceof MultiPoint) {
            this.writeGeometryCollection(4, (GeometryCollection)((MultiPoint)geom), os);
        } else if (geom instanceof MultiLineString) {
            this.writeGeometryCollection(5, (GeometryCollection)((MultiLineString)geom), os);
        } else if (geom instanceof MultiPolygon) {
            this.writeGeometryCollection(6, (GeometryCollection)((MultiPolygon)geom), os);
        } else if (geom instanceof GeometryCollection) {
            this.writeGeometryCollection(7, (GeometryCollection)geom, os);
        } else {
            Assert.shouldNeverReachHere((String)"Unknown Geometry type");
        }
    }

    private void writePoint(Point pt, OutStream os) throws IOException {
        if (pt.getCoordinateSequence().size() == 0) {
            throw new IllegalArgumentException("Empty Points cannot be represented in WKB");
        }
        this.writeByteOrder(os);
        this.writeGeometryType(1, os);
        this.writeCoordinateSequence(pt.getCoordinateSequence(), false, os);
    }

    private void writeLineString(LineString line, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(2, os);
        this.writeCoordinateSequence(line.getCoordinateSequence(), true, os);
    }

    private void writePolygon(Polygon poly, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(3, os);
        this.writeInt(poly.getNumInteriorRing() + 1, os);
        this.writeCoordinateSequence(poly.getExteriorRing().getCoordinateSequence(), true, os);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.writeCoordinateSequence(poly.getInteriorRingN(i).getCoordinateSequence(), true, os);
        }
    }

    private void writeGeometryCollection(int geometryType, GeometryCollection gc, OutStream os) throws IOException {
        this.writeByteOrder(os);
        this.writeGeometryType(geometryType, os);
        this.writeInt(gc.getNumGeometries(), os);
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            this.write(gc.getGeometryN(i), os);
        }
    }

    private void writeByteOrder(OutStream os) throws IOException {
        this.buf[0] = this.byteOrder == 2 ? (byte)1 : 0;
        os.write(this.buf, 1);
    }

    private void writeGeometryType(int geometryType, OutStream os) throws IOException {
        int typeInt = geometryType;
        if (this.outputDimension == 3) {
            if (this.hasOGCWkbZTyps) {
                if (geometryType == 1) {
                    typeInt = 1001;
                }
                if (geometryType == 2) {
                    typeInt = 1002;
                }
                if (geometryType == 3) {
                    typeInt = 1003;
                }
                if (geometryType == 4) {
                    typeInt = 1004;
                }
                if (geometryType == 5) {
                    typeInt = 1005;
                }
                if (geometryType == 6) {
                    typeInt = 1006;
                }
                if (geometryType == 7) {
                    typeInt = 1007;
                }
            } else {
                if (geometryType == 1) {
                    typeInt = 3000001;
                }
                if (geometryType == 2) {
                    typeInt = 3000002;
                }
                if (geometryType == 3) {
                    typeInt = 3000005;
                }
                if (geometryType == 4) {
                    typeInt = 3000007;
                }
                if (geometryType == 5) {
                    typeInt = 3000009;
                }
                if (geometryType == 6) {
                    typeInt = 3000011;
                }
                if (geometryType == 7) {
                    typeInt = 3000012;
                }
            }
        }
        this.writeInt(typeInt, os);
    }

    private void writeInt(int intValue, OutStream os) throws IOException {
        ByteOrderValues.putInt((int)intValue, (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 4);
    }

    private void writeCoordinateSequence(CoordinateSequence seq, boolean writeSize, OutStream os) throws IOException {
        if (writeSize) {
            this.writeInt(seq.size(), os);
        }
        for (int i = 0; i < seq.size(); ++i) {
            this.writeCoordinate(seq, i, os);
        }
    }

    private void writeCoordinate(CoordinateSequence seq, int index, OutStream os) throws IOException {
        ByteOrderValues.putDouble((double)seq.getX(index), (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 8);
        ByteOrderValues.putDouble((double)seq.getY(index), (byte[])this.buf, (int)this.byteOrder);
        os.write(this.buf, 8);
        if (this.outputDimension >= 3) {
            double ordVal = Double.NaN;
            if (seq.getDimension() >= 3) {
                ordVal = seq.getOrdinate(index, 2);
            }
            ByteOrderValues.putDouble((double)ordVal, (byte[])this.buf, (int)this.byteOrder);
            os.write(this.buf, 8);
        }
    }

    public int getOutputDimension() {
        return this.outputDimension;
    }

    static class DimensionCoordFilter
    implements CoordinateFilter {
        int dimension = 2;

        DimensionCoordFilter() {
        }

        public void filter(Coordinate coord) {
            if (this.dimension == 3) {
                return;
            }
            if (!Double.isNaN(coord.getZ())) {
                this.dimension = 3;
            }
        }

        int getDimension() {
            return this.dimension;
        }
    }
}

